
_ssd1306_command:

;ssd1306oled.c,314 :: 		void ssd1306_command(uint8_t c) {
;ssd1306oled.c,315 :: 		SSD1306_Start();
	CALL       _I2C1_Start+0
;ssd1306oled.c,316 :: 		SSD1306_Write(_i2caddr);
	MOVF       __i2caddr+0, 0
	MOVWF      FARG_I2C1_Wr_data_+0
	CALL       _I2C1_Wr+0
;ssd1306oled.c,317 :: 		SSD1306_Write(0);
	CLRF       FARG_I2C1_Wr_data_+0
	CALL       _I2C1_Wr+0
;ssd1306oled.c,318 :: 		SSD1306_Write(c);
	MOVF       FARG_ssd1306_command_c+0, 0
	MOVWF      FARG_I2C1_Wr_data_+0
	CALL       _I2C1_Wr+0
;ssd1306oled.c,319 :: 		SSD1306_Stop();
	CALL       _I2C1_Stop+0
;ssd1306oled.c,320 :: 		}
L_end_ssd1306_command:
	RETURN
; end of _ssd1306_command

_SSD1306_Begin:

;ssd1306oled.c,322 :: 		void SSD1306_Begin(uint8_t vccstate, uint8_t i2caddr) {
;ssd1306oled.c,323 :: 		_vccstate = vccstate;
	MOVF       FARG_SSD1306_Begin_vccstate+0, 0
	MOVWF      __vccstate+0
;ssd1306oled.c,324 :: 		_i2caddr  = i2caddr;
	MOVF       FARG_SSD1306_Begin_i2caddr+0, 0
	MOVWF      __i2caddr+0
;ssd1306oled.c,334 :: 		ssd1306_command(SSD1306_DISPLAYOFF);                    // 0xAE
	MOVLW      174
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,335 :: 		ssd1306_command(SSD1306_SETDISPLAYCLOCKDIV);            // 0xD5
	MOVLW      213
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,336 :: 		ssd1306_command(0x80);                                  // the suggested ratio 0x80
	MOVLW      128
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,338 :: 		ssd1306_command(SSD1306_SETMULTIPLEX);                  // 0xA8
	MOVLW      168
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,339 :: 		ssd1306_command(SSD1306_LCDHEIGHT - 1);
	MOVLW      31
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,341 :: 		ssd1306_command(SSD1306_SETDISPLAYOFFSET);              // 0xD3
	MOVLW      211
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,342 :: 		ssd1306_command(0x0);                                   // no offset
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,343 :: 		ssd1306_command(SSD1306_SETSTARTLINE | 0x0);            // line #0
	MOVLW      64
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,344 :: 		ssd1306_command(SSD1306_CHARGEPUMP);                    // 0x8D
	MOVLW      141
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,345 :: 		if (vccstate == SSD1306_EXTERNALVCC)
	MOVF       FARG_SSD1306_Begin_vccstate+0, 0
	XORLW      1
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_Begin0
;ssd1306oled.c,346 :: 		{ ssd1306_command(0x10); }
	MOVLW      16
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
	GOTO       L_SSD1306_Begin1
L_SSD1306_Begin0:
;ssd1306oled.c,348 :: 		{ ssd1306_command(0x14); }
	MOVLW      20
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
L_SSD1306_Begin1:
;ssd1306oled.c,349 :: 		ssd1306_command(SSD1306_MEMORYMODE);                    // 0x20
	MOVLW      32
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,350 :: 		ssd1306_command(0x00);                                  // 0x0 act like ks0108
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,351 :: 		ssd1306_command(SSD1306_SEGREMAP | 0x1);
	MOVLW      161
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,352 :: 		ssd1306_command(SSD1306_COMSCANDEC);
	MOVLW      200
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,355 :: 		ssd1306_command(SSD1306_SETCOMPINS);                    // 0xDA
	MOVLW      218
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,356 :: 		ssd1306_command(0x02);
	MOVLW      2
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,357 :: 		ssd1306_command(SSD1306_SETCONTRAST);                   // 0x81
	MOVLW      129
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,358 :: 		ssd1306_command(0x8F);
	MOVLW      143
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,380 :: 		ssd1306_command(SSD1306_SETPRECHARGE);                  // 0xd9
	MOVLW      217
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,381 :: 		if (vccstate == SSD1306_EXTERNALVCC)
	MOVF       FARG_SSD1306_Begin_vccstate+0, 0
	XORLW      1
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_Begin2
;ssd1306oled.c,382 :: 		{ ssd1306_command(0x22); }
	MOVLW      34
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
	GOTO       L_SSD1306_Begin3
L_SSD1306_Begin2:
;ssd1306oled.c,384 :: 		{ ssd1306_command(0xF1); }
	MOVLW      241
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
L_SSD1306_Begin3:
;ssd1306oled.c,385 :: 		ssd1306_command(SSD1306_SETVCOMDETECT);                 // 0xDB
	MOVLW      219
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,386 :: 		ssd1306_command(0x40);
	MOVLW      64
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,387 :: 		ssd1306_command(SSD1306_DISPLAYALLON_RESUME);           // 0xA4
	MOVLW      164
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,388 :: 		ssd1306_command(SSD1306_NORMALDISPLAY);                 // 0xA6
	MOVLW      166
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,390 :: 		ssd1306_command(SSD1306_DEACTIVATE_SCROLL);
	MOVLW      46
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,392 :: 		ssd1306_command(SSD1306_DISPLAYON);//--turn on oled panel
	MOVLW      175
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,393 :: 		}
L_end_SSD1306_Begin:
	RETURN
; end of _SSD1306_Begin

_SSD1306_DrawPixel:

;ssd1306oled.c,395 :: 		void SSD1306_DrawPixel(uint8_t x, uint8_t y) {
;ssd1306oled.c,396 :: 		if ((x >= SSD1306_LCDWIDTH) || (y >= SSD1306_LCDHEIGHT))
	MOVLW      128
	SUBWF      FARG_SSD1306_DrawPixel_x+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L__SSD1306_DrawPixel168
	MOVLW      32
	SUBWF      FARG_SSD1306_DrawPixel_y+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L__SSD1306_DrawPixel168
	GOTO       L_SSD1306_DrawPixel6
L__SSD1306_DrawPixel168:
;ssd1306oled.c,397 :: 		return;
	GOTO       L_end_SSD1306_DrawPixel
L_SSD1306_DrawPixel6:
;ssd1306oled.c,398 :: 		if (SSD1306_Color)
	MOVF       _SSD1306_Color+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_DrawPixel7
;ssd1306oled.c,399 :: 		buffer[x + (uint16_t)(y / 8) * SSD1306_LCDWIDTH] |=  (1 << (y & 7));
	MOVF       FARG_SSD1306_DrawPixel_y+0, 0
	MOVWF      R0
	LSRF       R0, 1
	LSRF       R0, 1
	LSRF       R0, 1
	MOVF       R0, 0
	MOVWF      R3
	CLRF       R4
	MOVLW      7
	MOVWF      R2
	MOVF       R3, 0
	MOVWF      R0
	MOVF       R4, 0
	MOVWF      R1
	MOVF       R2, 0
L__SSD1306_DrawPixel178:
	BTFSC      STATUS+0, 2
	GOTO       L__SSD1306_DrawPixel179
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__SSD1306_DrawPixel178
L__SSD1306_DrawPixel179:
	MOVF       FARG_SSD1306_DrawPixel_x+0, 0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      si5351SDR_firmware_buffer+0
	MOVWF      R0
	MOVLW      hi_addr(si5351SDR_firmware_buffer+0)
	MOVWF      R1
	MOVF       R2, 0
	ADDWF      R0, 0
	MOVWF      R4
	MOVF       R3, 0
	ADDWFC     R1, 0
	MOVWF      R5
	MOVLW      7
	ANDWF      FARG_SSD1306_DrawPixel_y+0, 0
	MOVWF      R0
	MOVF       R0, 0
	MOVWF      R1
	MOVLW      1
	MOVWF      R0
	MOVF       R1, 0
L__SSD1306_DrawPixel180:
	BTFSC      STATUS+0, 2
	GOTO       L__SSD1306_DrawPixel181
	LSLF       R0, 1
	ADDLW      255
	GOTO       L__SSD1306_DrawPixel180
L__SSD1306_DrawPixel181:
	MOVF       R4, 0
	MOVWF      FSR0L
	MOVF       R5, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	IORWF       R0, 1
	MOVF       R4, 0
	MOVWF      FSR1L
	MOVF       R5, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
	GOTO       L_SSD1306_DrawPixel8
L_SSD1306_DrawPixel7:
;ssd1306oled.c,401 :: 		buffer[x + (uint16_t)(y / 8) * SSD1306_LCDWIDTH] &=  ~(1 << (y & 7));
	MOVF       FARG_SSD1306_DrawPixel_y+0, 0
	MOVWF      R0
	LSRF       R0, 1
	LSRF       R0, 1
	LSRF       R0, 1
	MOVF       R0, 0
	MOVWF      R3
	CLRF       R4
	MOVLW      7
	MOVWF      R2
	MOVF       R3, 0
	MOVWF      R0
	MOVF       R4, 0
	MOVWF      R1
	MOVF       R2, 0
L__SSD1306_DrawPixel182:
	BTFSC      STATUS+0, 2
	GOTO       L__SSD1306_DrawPixel183
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__SSD1306_DrawPixel182
L__SSD1306_DrawPixel183:
	MOVF       FARG_SSD1306_DrawPixel_x+0, 0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      si5351SDR_firmware_buffer+0
	MOVWF      R0
	MOVLW      hi_addr(si5351SDR_firmware_buffer+0)
	MOVWF      R1
	MOVF       R2, 0
	ADDWF      R0, 0
	MOVWF      R4
	MOVF       R3, 0
	ADDWFC     R1, 0
	MOVWF      R5
	MOVLW      7
	ANDWF      FARG_SSD1306_DrawPixel_y+0, 0
	MOVWF      R0
	MOVF       R0, 0
	MOVWF      R1
	MOVLW      1
	MOVWF      R0
	MOVF       R1, 0
L__SSD1306_DrawPixel184:
	BTFSC      STATUS+0, 2
	GOTO       L__SSD1306_DrawPixel185
	LSLF       R0, 1
	ADDLW      255
	GOTO       L__SSD1306_DrawPixel184
L__SSD1306_DrawPixel185:
	COMF       R0, 1
	MOVF       R4, 0
	MOVWF      FSR0L
	MOVF       R5, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	ANDWF      R0, 1
	MOVF       R4, 0
	MOVWF      FSR1L
	MOVF       R5, 0
	MOVWF      FSR1H
	MOVF       R0, 0
	MOVWF      INDF1+0
L_SSD1306_DrawPixel8:
;ssd1306oled.c,402 :: 		}
L_end_SSD1306_DrawPixel:
	RETURN
; end of _SSD1306_DrawPixel

_SSD1306_StartScrollRight:

;ssd1306oled.c,404 :: 		void SSD1306_StartScrollRight(uint8_t start, uint8_t stop) {
;ssd1306oled.c,405 :: 		ssd1306_command(SSD1306_RIGHT_HORIZONTAL_SCROLL);
	MOVLW      38
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,406 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,407 :: 		ssd1306_command(start);
	MOVF       FARG_SSD1306_StartScrollRight_start+0, 0
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,408 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,409 :: 		ssd1306_command(stop);
	MOVF       FARG_SSD1306_StartScrollRight_stop+0, 0
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,410 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,411 :: 		ssd1306_command(0XFF);
	MOVLW      255
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,412 :: 		ssd1306_command(SSD1306_ACTIVATE_SCROLL);
	MOVLW      47
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,413 :: 		}
L_end_SSD1306_StartScrollRight:
	RETURN
; end of _SSD1306_StartScrollRight

_SSD1306_StartScrollLeft:

;ssd1306oled.c,415 :: 		void SSD1306_StartScrollLeft(uint8_t start, uint8_t stop) {
;ssd1306oled.c,416 :: 		ssd1306_command(SSD1306_LEFT_HORIZONTAL_SCROLL);
	MOVLW      39
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,417 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,418 :: 		ssd1306_command(start);
	MOVF       FARG_SSD1306_StartScrollLeft_start+0, 0
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,419 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,420 :: 		ssd1306_command(stop);
	MOVF       FARG_SSD1306_StartScrollLeft_stop+0, 0
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,421 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,422 :: 		ssd1306_command(0XFF);
	MOVLW      255
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,423 :: 		ssd1306_command(SSD1306_ACTIVATE_SCROLL);
	MOVLW      47
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,424 :: 		}
L_end_SSD1306_StartScrollLeft:
	RETURN
; end of _SSD1306_StartScrollLeft

_SSD1306_StartScrollDiagRight:

;ssd1306oled.c,426 :: 		void SSD1306_StartScrollDiagRight(uint8_t start, uint8_t stop) {
;ssd1306oled.c,427 :: 		ssd1306_command(SSD1306_SET_VERTICAL_SCROLL_AREA);
	MOVLW      163
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,428 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,429 :: 		ssd1306_command(SSD1306_LCDHEIGHT);
	MOVLW      32
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,430 :: 		ssd1306_command(SSD1306_VERTICAL_AND_RIGHT_HORIZONTAL_SCROLL);
	MOVLW      41
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,431 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,432 :: 		ssd1306_command(start);
	MOVF       FARG_SSD1306_StartScrollDiagRight_start+0, 0
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,433 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,434 :: 		ssd1306_command(stop);
	MOVF       FARG_SSD1306_StartScrollDiagRight_stop+0, 0
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,435 :: 		ssd1306_command(0X01);
	MOVLW      1
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,436 :: 		ssd1306_command(SSD1306_ACTIVATE_SCROLL);
	MOVLW      47
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,437 :: 		}
L_end_SSD1306_StartScrollDiagRight:
	RETURN
; end of _SSD1306_StartScrollDiagRight

_SSD1306_StartScrollDiagLeft:

;ssd1306oled.c,439 :: 		void SSD1306_StartScrollDiagLeft(uint8_t start, uint8_t stop) {
;ssd1306oled.c,440 :: 		ssd1306_command(SSD1306_SET_VERTICAL_SCROLL_AREA);
	MOVLW      163
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,441 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,442 :: 		ssd1306_command(SSD1306_LCDHEIGHT);
	MOVLW      32
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,443 :: 		ssd1306_command(SSD1306_VERTICAL_AND_LEFT_HORIZONTAL_SCROLL);
	MOVLW      42
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,444 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,445 :: 		ssd1306_command(start);
	MOVF       FARG_SSD1306_StartScrollDiagLeft_start+0, 0
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,446 :: 		ssd1306_command(0X00);
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,447 :: 		ssd1306_command(stop);
	MOVF       FARG_SSD1306_StartScrollDiagLeft_stop+0, 0
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,448 :: 		ssd1306_command(0X01);
	MOVLW      1
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,449 :: 		ssd1306_command(SSD1306_ACTIVATE_SCROLL);
	MOVLW      47
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,450 :: 		}
L_end_SSD1306_StartScrollDiagLeft:
	RETURN
; end of _SSD1306_StartScrollDiagLeft

_SSD1306_StopScroll:

;ssd1306oled.c,452 :: 		void SSD1306_StopScroll(void) {
;ssd1306oled.c,453 :: 		ssd1306_command(SSD1306_DEACTIVATE_SCROLL);
	MOVLW      46
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,454 :: 		}
L_end_SSD1306_StopScroll:
	RETURN
; end of _SSD1306_StopScroll

_SSD1306_Dim:

;ssd1306oled.c,456 :: 		void SSD1306_Dim(bool dim) {
;ssd1306oled.c,458 :: 		if (dim)
	MOVF       FARG_SSD1306_Dim_dim+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_Dim9
;ssd1306oled.c,459 :: 		contrast = 0; // Dimmed display
	CLRF       SSD1306_Dim_contrast_L0+0
	GOTO       L_SSD1306_Dim10
L_SSD1306_Dim9:
;ssd1306oled.c,461 :: 		if (_vccstate == SSD1306_EXTERNALVCC)
	MOVF       __vccstate+0, 0
	XORLW      1
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_Dim11
;ssd1306oled.c,462 :: 		contrast = 0x9F;
	MOVLW      159
	MOVWF      SSD1306_Dim_contrast_L0+0
	GOTO       L_SSD1306_Dim12
L_SSD1306_Dim11:
;ssd1306oled.c,464 :: 		contrast = 0xCF;
	MOVLW      207
	MOVWF      SSD1306_Dim_contrast_L0+0
L_SSD1306_Dim12:
;ssd1306oled.c,465 :: 		}
L_SSD1306_Dim10:
;ssd1306oled.c,468 :: 		ssd1306_command(SSD1306_SETCONTRAST);
	MOVLW      129
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,469 :: 		ssd1306_command(contrast);
	MOVF       SSD1306_Dim_contrast_L0+0, 0
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,470 :: 		}
L_end_SSD1306_Dim:
	RETURN
; end of _SSD1306_Dim

_SSD1306_Display:

;ssd1306oled.c,472 :: 		void SSD1306_Display(void) {
;ssd1306oled.c,475 :: 		ssd1306_command(SSD1306_COLUMNADDR);
	MOVLW      33
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,476 :: 		ssd1306_command(0);   // Column start address (0 = reset)
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,477 :: 		ssd1306_command(SSD1306_LCDWIDTH-1); // Column end address (127 = reset)
	MOVLW      127
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,479 :: 		ssd1306_command(SSD1306_PAGEADDR);
	MOVLW      34
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,480 :: 		ssd1306_command(0); // Page start address (0 = reset)
	CLRF       FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,485 :: 		ssd1306_command(3); // Page end address
	MOVLW      3
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
;ssd1306oled.c,491 :: 		for (i = 0; i < (SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT / 8); i++) {
	CLRF       SSD1306_Display_i_L0+0
	CLRF       SSD1306_Display_i_L0+1
L_SSD1306_Display13:
	MOVLW      2
	SUBWF      SSD1306_Display_i_L0+1, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_Display193
	MOVLW      0
	SUBWF      SSD1306_Display_i_L0+0, 0
L__SSD1306_Display193:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_Display14
;ssd1306oled.c,493 :: 		SSD1306_Start();
	CALL       _I2C1_Start+0
;ssd1306oled.c,494 :: 		SSD1306_Write(_i2caddr);
	MOVF       __i2caddr+0, 0
	MOVWF      FARG_I2C1_Wr_data_+0
	CALL       _I2C1_Wr+0
;ssd1306oled.c,495 :: 		SSD1306_Write(0x40);
	MOVLW      64
	MOVWF      FARG_I2C1_Wr_data_+0
	CALL       _I2C1_Wr+0
;ssd1306oled.c,496 :: 		for (x = 0; x < 16; x++) {
	CLRF       SSD1306_Display_x_L0+0
L_SSD1306_Display16:
	MOVLW      16
	SUBWF      SSD1306_Display_x_L0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_Display17
;ssd1306oled.c,497 :: 		SSD1306_Write(buffer[i]);
	MOVLW      si5351SDR_firmware_buffer+0
	MOVWF      R0
	MOVLW      hi_addr(si5351SDR_firmware_buffer+0)
	MOVWF      R1
	MOVF       SSD1306_Display_i_L0+0, 0
	ADDWF      R0, 0
	MOVWF      FSR0L
	MOVF       SSD1306_Display_i_L0+1, 0
	ADDWFC     R1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      FARG_I2C1_Wr_data_+0
	CALL       _I2C1_Wr+0
;ssd1306oled.c,498 :: 		i++;
	INCF       SSD1306_Display_i_L0+0, 1
	BTFSC      STATUS+0, 2
	INCF       SSD1306_Display_i_L0+1, 1
;ssd1306oled.c,496 :: 		for (x = 0; x < 16; x++) {
	INCF       SSD1306_Display_x_L0+0, 1
;ssd1306oled.c,499 :: 		}
	GOTO       L_SSD1306_Display16
L_SSD1306_Display17:
;ssd1306oled.c,500 :: 		i--;
	MOVLW      1
	SUBWF      SSD1306_Display_i_L0+0, 1
	MOVLW      0
	SUBWFB     SSD1306_Display_i_L0+1, 1
;ssd1306oled.c,501 :: 		SSD1306_Stop();
	CALL       _I2C1_Stop+0
;ssd1306oled.c,491 :: 		for (i = 0; i < (SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT / 8); i++) {
	INCF       SSD1306_Display_i_L0+0, 1
	BTFSC      STATUS+0, 2
	INCF       SSD1306_Display_i_L0+1, 1
;ssd1306oled.c,502 :: 		}
	GOTO       L_SSD1306_Display13
L_SSD1306_Display14:
;ssd1306oled.c,503 :: 		}
L_end_SSD1306_Display:
	RETURN
; end of _SSD1306_Display

_SSD1306_ClearDisplay:

;ssd1306oled.c,505 :: 		void SSD1306_ClearDisplay(void) {
;ssd1306oled.c,507 :: 		for (i = 0; i < (SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT / 8); i++)
	CLRF       R2+0
	CLRF       R2+1
L_SSD1306_ClearDisplay19:
	MOVLW      128
	XORWF      R2+1, 0
	MOVWF      R0
	MOVLW      128
	XORLW      2
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_ClearDisplay195
	MOVLW      0
	SUBWF      R2+0, 0
L__SSD1306_ClearDisplay195:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_ClearDisplay20
;ssd1306oled.c,508 :: 		buffer[i] = 0;
	MOVLW      si5351SDR_firmware_buffer+0
	MOVWF      R0
	MOVLW      hi_addr(si5351SDR_firmware_buffer+0)
	MOVWF      R1
	MOVF       R2+0, 0
	ADDWF      R0, 0
	MOVWF      FSR1L
	MOVF       R2+1, 0
	ADDWFC     R1, 0
	MOVWF      FSR1H
	CLRF       INDF1+0
;ssd1306oled.c,507 :: 		for (i = 0; i < (SSD1306_LCDWIDTH*SSD1306_LCDHEIGHT / 8); i++)
	INCF       R2+0, 1
	BTFSC      STATUS+0, 2
	INCF       R2+1, 1
;ssd1306oled.c,508 :: 		buffer[i] = 0;
	GOTO       L_SSD1306_ClearDisplay19
L_SSD1306_ClearDisplay20:
;ssd1306oled.c,509 :: 		}
L_end_SSD1306_ClearDisplay:
	RETURN
; end of _SSD1306_ClearDisplay

_SSD1306_DrawLine:

;ssd1306oled.c,511 :: 		void SSD1306_DrawLine(int16_t x0, int16_t y0, int16_t x1, int16_t y1) {
;ssd1306oled.c,516 :: 		steep = abs(y1 - y0) > abs(x1 - x0);
	MOVF       FARG_SSD1306_DrawLine_y0+0, 0
	SUBWF      FARG_SSD1306_DrawLine_y1+0, 0
	MOVWF      FARG_abs_a+0
	MOVF       FARG_SSD1306_DrawLine_y0+1, 0
	SUBWFB     FARG_SSD1306_DrawLine_y1+1, 0
	MOVWF      FARG_abs_a+1
	CALL       _abs+0
	MOVF       R0, 0
	MOVWF      FLOC__SSD1306_DrawLine+0
	MOVF       R1, 0
	MOVWF      FLOC__SSD1306_DrawLine+1
	MOVF       FARG_SSD1306_DrawLine_x0+0, 0
	SUBWF      FARG_SSD1306_DrawLine_x1+0, 0
	MOVWF      FARG_abs_a+0
	MOVF       FARG_SSD1306_DrawLine_x0+1, 0
	SUBWFB     FARG_SSD1306_DrawLine_x1+1, 0
	MOVWF      FARG_abs_a+1
	CALL       _abs+0
	MOVLW      128
	XORWF      R1, 0
	MOVWF      R2
	MOVLW      128
	XORWF      FLOC__SSD1306_DrawLine+1, 0
	SUBWF      R2, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawLine197
	MOVF       FLOC__SSD1306_DrawLine+0, 0
	SUBWF      R0, 0
L__SSD1306_DrawLine197:
	MOVLW      1
	BTFSC      STATUS+0, 0
	MOVLW      0
	MOVWF      R2
	MOVF       R2, 0
	MOVWF      SSD1306_DrawLine_steep_L0+0
;ssd1306oled.c,517 :: 		if (steep) {
	MOVF       R2, 0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_DrawLine22
;ssd1306oled.c,518 :: 		ssd1306_swap(x0, y0);
	MOVF       FARG_SSD1306_DrawLine_x0+0, 0
	MOVWF      SSD1306_DrawLine_t_L2+0
	MOVF       FARG_SSD1306_DrawLine_x0+1, 0
	MOVWF      SSD1306_DrawLine_t_L2+1
	MOVF       FARG_SSD1306_DrawLine_y0+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x0+0
	MOVF       FARG_SSD1306_DrawLine_y0+1, 0
	MOVWF      FARG_SSD1306_DrawLine_x0+1
	MOVF       SSD1306_DrawLine_t_L2+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y0+0
	MOVF       SSD1306_DrawLine_t_L2+1, 0
	MOVWF      FARG_SSD1306_DrawLine_y0+1
;ssd1306oled.c,519 :: 		ssd1306_swap(x1, y1);
	MOVF       FARG_SSD1306_DrawLine_x1+0, 0
	MOVWF      SSD1306_DrawLine_t_L2_L2+0
	MOVF       FARG_SSD1306_DrawLine_x1+1, 0
	MOVWF      SSD1306_DrawLine_t_L2_L2+1
	MOVF       FARG_SSD1306_DrawLine_y1+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x1+0
	MOVF       FARG_SSD1306_DrawLine_y1+1, 0
	MOVWF      FARG_SSD1306_DrawLine_x1+1
	MOVF       SSD1306_DrawLine_t_L2_L2+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y1+0
	MOVF       SSD1306_DrawLine_t_L2_L2+1, 0
	MOVWF      FARG_SSD1306_DrawLine_y1+1
;ssd1306oled.c,520 :: 		}
L_SSD1306_DrawLine22:
;ssd1306oled.c,521 :: 		if (x0 > x1) {
	MOVLW      128
	XORWF      FARG_SSD1306_DrawLine_x1+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FARG_SSD1306_DrawLine_x0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawLine198
	MOVF       FARG_SSD1306_DrawLine_x0+0, 0
	SUBWF      FARG_SSD1306_DrawLine_x1+0, 0
L__SSD1306_DrawLine198:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_DrawLine23
;ssd1306oled.c,522 :: 		ssd1306_swap(x0, x1);
	MOVF       FARG_SSD1306_DrawLine_x0+0, 0
	MOVWF      SSD1306_DrawLine_t_L2_L2_L2+0
	MOVF       FARG_SSD1306_DrawLine_x0+1, 0
	MOVWF      SSD1306_DrawLine_t_L2_L2_L2+1
	MOVF       FARG_SSD1306_DrawLine_x1+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x0+0
	MOVF       FARG_SSD1306_DrawLine_x1+1, 0
	MOVWF      FARG_SSD1306_DrawLine_x0+1
	MOVF       SSD1306_DrawLine_t_L2_L2_L2+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x1+0
	MOVF       SSD1306_DrawLine_t_L2_L2_L2+1, 0
	MOVWF      FARG_SSD1306_DrawLine_x1+1
;ssd1306oled.c,523 :: 		ssd1306_swap(y0, y1);
	MOVF       FARG_SSD1306_DrawLine_y0+0, 0
	MOVWF      SSD1306_DrawLine_t_L2_L2_L2_L2+0
	MOVF       FARG_SSD1306_DrawLine_y0+1, 0
	MOVWF      SSD1306_DrawLine_t_L2_L2_L2_L2+1
	MOVF       FARG_SSD1306_DrawLine_y1+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y0+0
	MOVF       FARG_SSD1306_DrawLine_y1+1, 0
	MOVWF      FARG_SSD1306_DrawLine_y0+1
	MOVF       SSD1306_DrawLine_t_L2_L2_L2_L2+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y1+0
	MOVF       SSD1306_DrawLine_t_L2_L2_L2_L2+1, 0
	MOVWF      FARG_SSD1306_DrawLine_y1+1
;ssd1306oled.c,524 :: 		}
L_SSD1306_DrawLine23:
;ssd1306oled.c,525 :: 		dx = x1 - x0;
	MOVF       FARG_SSD1306_DrawLine_x0+0, 0
	SUBWF      FARG_SSD1306_DrawLine_x1+0, 0
	MOVWF      SSD1306_DrawLine_dx_L0+0
;ssd1306oled.c,526 :: 		dy = abs(y1 - y0);
	MOVF       FARG_SSD1306_DrawLine_y0+0, 0
	SUBWF      FARG_SSD1306_DrawLine_y1+0, 0
	MOVWF      FARG_abs_a+0
	MOVF       FARG_SSD1306_DrawLine_y0+1, 0
	SUBWFB     FARG_SSD1306_DrawLine_y1+1, 0
	MOVWF      FARG_abs_a+1
	CALL       _abs+0
	MOVF       R0, 0
	MOVWF      SSD1306_DrawLine_dy_L0+0
;ssd1306oled.c,528 :: 		err = dx / 2;
	MOVF       SSD1306_DrawLine_dx_L0+0, 0
	MOVWF      SSD1306_DrawLine_err_L0+0
	CLRF       SSD1306_DrawLine_err_L0+1
	LSRF       SSD1306_DrawLine_err_L0+0, 1
	MOVLW      0
	MOVWF      SSD1306_DrawLine_err_L0+1
;ssd1306oled.c,529 :: 		if (y0 < y1)
	MOVLW      128
	XORWF      FARG_SSD1306_DrawLine_y0+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FARG_SSD1306_DrawLine_y1+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawLine199
	MOVF       FARG_SSD1306_DrawLine_y1+0, 0
	SUBWF      FARG_SSD1306_DrawLine_y0+0, 0
L__SSD1306_DrawLine199:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_DrawLine24
;ssd1306oled.c,530 :: 		ystep = 1;
	MOVLW      1
	MOVWF      SSD1306_DrawLine_ystep_L0+0
	GOTO       L_SSD1306_DrawLine25
L_SSD1306_DrawLine24:
;ssd1306oled.c,532 :: 		ystep = -1;
	MOVLW      255
	MOVWF      SSD1306_DrawLine_ystep_L0+0
L_SSD1306_DrawLine25:
;ssd1306oled.c,534 :: 		for (; x0 <= x1; x0++) {
L_SSD1306_DrawLine26:
	MOVLW      128
	XORWF      FARG_SSD1306_DrawLine_x1+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FARG_SSD1306_DrawLine_x0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawLine200
	MOVF       FARG_SSD1306_DrawLine_x0+0, 0
	SUBWF      FARG_SSD1306_DrawLine_x1+0, 0
L__SSD1306_DrawLine200:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_DrawLine27
;ssd1306oled.c,535 :: 		if (steep)
	MOVF       SSD1306_DrawLine_steep_L0+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_DrawLine29
;ssd1306oled.c,536 :: 		SSD1306_DrawPixel(y0, x0);
	MOVF       FARG_SSD1306_DrawLine_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       FARG_SSD1306_DrawLine_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
	GOTO       L_SSD1306_DrawLine30
L_SSD1306_DrawLine29:
;ssd1306oled.c,538 :: 		SSD1306_DrawPixel(x0, y0);
	MOVF       FARG_SSD1306_DrawLine_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       FARG_SSD1306_DrawLine_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
L_SSD1306_DrawLine30:
;ssd1306oled.c,539 :: 		err -= dy;
	MOVF       SSD1306_DrawLine_dy_L0+0, 0
	SUBWF      SSD1306_DrawLine_err_L0+0, 0
	MOVWF      R1
	MOVLW      0
	SUBWFB     SSD1306_DrawLine_err_L0+1, 0
	MOVWF      R2
	MOVF       R1, 0
	MOVWF      SSD1306_DrawLine_err_L0+0
	MOVF       R2, 0
	MOVWF      SSD1306_DrawLine_err_L0+1
;ssd1306oled.c,540 :: 		if (err < 0) {
	MOVLW      128
	XORWF      R2, 0
	MOVWF      R0
	MOVLW      128
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawLine201
	MOVLW      0
	SUBWF      R1, 0
L__SSD1306_DrawLine201:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_DrawLine31
;ssd1306oled.c,541 :: 		y0  += ystep;
	MOVF       SSD1306_DrawLine_ystep_L0+0, 0
	ADDWF      FARG_SSD1306_DrawLine_y0+0, 1
	MOVLW      0
	BTFSC      SSD1306_DrawLine_ystep_L0+0, 7
	MOVLW      255
	ADDWFC     FARG_SSD1306_DrawLine_y0+1, 1
;ssd1306oled.c,542 :: 		err += dx;
	MOVF       SSD1306_DrawLine_dx_L0+0, 0
	ADDWF      SSD1306_DrawLine_err_L0+0, 1
	MOVLW      0
	ADDWFC     SSD1306_DrawLine_err_L0+1, 1
;ssd1306oled.c,543 :: 		}
L_SSD1306_DrawLine31:
;ssd1306oled.c,534 :: 		for (; x0 <= x1; x0++) {
	INCF       FARG_SSD1306_DrawLine_x0+0, 1
	BTFSC      STATUS+0, 2
	INCF       FARG_SSD1306_DrawLine_x0+1, 1
;ssd1306oled.c,544 :: 		}
	GOTO       L_SSD1306_DrawLine26
L_SSD1306_DrawLine27:
;ssd1306oled.c,545 :: 		}
L_end_SSD1306_DrawLine:
	RETURN
; end of _SSD1306_DrawLine

_SSD1306_DrawFastHLine:

;ssd1306oled.c,547 :: 		void SSD1306_DrawFastHLine(uint8_t x, uint8_t y, uint8_t w) {
;ssd1306oled.c,548 :: 		SSD1306_DrawLine(x, y, x + w - 1, y);
	MOVF       FARG_SSD1306_DrawFastHLine_x+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x0+0
	CLRF       FARG_SSD1306_DrawLine_x0+1
	MOVF       FARG_SSD1306_DrawFastHLine_y+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y0+0
	CLRF       FARG_SSD1306_DrawLine_y0+1
	MOVF       FARG_SSD1306_DrawFastHLine_w+0, 0
	ADDWF      FARG_SSD1306_DrawFastHLine_x+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x1+0
	CLRF       FARG_SSD1306_DrawLine_x1+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawLine_x1+1, 1
	MOVLW      1
	SUBWF      FARG_SSD1306_DrawLine_x1+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawLine_x1+1, 1
	MOVF       FARG_SSD1306_DrawFastHLine_y+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y1+0
	CLRF       FARG_SSD1306_DrawLine_y1+1
	CALL       _SSD1306_DrawLine+0
;ssd1306oled.c,549 :: 		}
L_end_SSD1306_DrawFastHLine:
	RETURN
; end of _SSD1306_DrawFastHLine

_SSD1306_DrawFastVLine:

;ssd1306oled.c,551 :: 		void SSD1306_DrawFastVLine(uint8_t x, uint8_t y, uint8_t h) {
;ssd1306oled.c,552 :: 		SSD1306_DrawLine(x, y, x, y + h - 1);
	MOVF       FARG_SSD1306_DrawFastVLine_x+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x0+0
	CLRF       FARG_SSD1306_DrawLine_x0+1
	MOVF       FARG_SSD1306_DrawFastVLine_y+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y0+0
	CLRF       FARG_SSD1306_DrawLine_y0+1
	MOVF       FARG_SSD1306_DrawFastVLine_x+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x1+0
	CLRF       FARG_SSD1306_DrawLine_x1+1
	MOVF       FARG_SSD1306_DrawFastVLine_h+0, 0
	ADDWF      FARG_SSD1306_DrawFastVLine_y+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y1+0
	CLRF       FARG_SSD1306_DrawLine_y1+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawLine_y1+1, 1
	MOVLW      1
	SUBWF      FARG_SSD1306_DrawLine_y1+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawLine_y1+1, 1
	CALL       _SSD1306_DrawLine+0
;ssd1306oled.c,553 :: 		}
L_end_SSD1306_DrawFastVLine:
	RETURN
; end of _SSD1306_DrawFastVLine

_SSD1306_FillRect:

;ssd1306oled.c,555 :: 		void SSD1306_FillRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h) {
;ssd1306oled.c,557 :: 		for (i = x; i < x + w; i++)
	MOVF       FARG_SSD1306_FillRect_x+0, 0
	MOVWF      SSD1306_FillRect_i_L0+0
	CLRF       SSD1306_FillRect_i_L0+1
L_SSD1306_FillRect32:
	MOVF       FARG_SSD1306_FillRect_w+0, 0
	ADDWF      FARG_SSD1306_FillRect_x+0, 0
	MOVWF      R1
	CLRF       R2
	MOVLW      0
	ADDWFC     R2, 1
	MOVLW      128
	XORWF      SSD1306_FillRect_i_L0+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      R2, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillRect205
	MOVF       R1, 0
	SUBWF      SSD1306_FillRect_i_L0+0, 0
L__SSD1306_FillRect205:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillRect33
;ssd1306oled.c,558 :: 		SSD1306_DrawFastVLine(i, y, h);
	MOVF       SSD1306_FillRect_i_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	MOVF       FARG_SSD1306_FillRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       FARG_SSD1306_FillRect_h+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,557 :: 		for (i = x; i < x + w; i++)
	INCF       SSD1306_FillRect_i_L0+0, 1
	BTFSC      STATUS+0, 2
	INCF       SSD1306_FillRect_i_L0+1, 1
;ssd1306oled.c,558 :: 		SSD1306_DrawFastVLine(i, y, h);
	GOTO       L_SSD1306_FillRect32
L_SSD1306_FillRect33:
;ssd1306oled.c,559 :: 		}
L_end_SSD1306_FillRect:
	RETURN
; end of _SSD1306_FillRect

_SSD1306_DrawCircle:

;ssd1306oled.c,561 :: 		void SSD1306_DrawCircle(int16_t x0, int16_t y0, int16_t r) {
;ssd1306oled.c,562 :: 		int16_t f = 1 - r;
	MOVF       FARG_SSD1306_DrawCircle_r+0, 0
	SUBLW      1
	MOVWF      SSD1306_DrawCircle_f_L0+0
	MOVF       FARG_SSD1306_DrawCircle_r+1, 0
	BTFSS      STATUS+0, 0
	ADDLW      1
	CLRF       SSD1306_DrawCircle_f_L0+1
	SUBWF      SSD1306_DrawCircle_f_L0+1, 1
;ssd1306oled.c,563 :: 		int16_t ddF_x = 1;
	MOVLW      1
	MOVWF      SSD1306_DrawCircle_ddF_x_L0+0
	MOVLW      0
	MOVWF      SSD1306_DrawCircle_ddF_x_L0+1
;ssd1306oled.c,564 :: 		int16_t ddF_y = -2 * r;
	MOVLW      254
	MOVWF      R0
	MOVLW      255
	MOVWF      R1
	MOVF       FARG_SSD1306_DrawCircle_r+0, 0
	MOVWF      R4
	MOVF       FARG_SSD1306_DrawCircle_r+1, 0
	MOVWF      R5
	CALL       _Mul_16X16_U+0
	MOVF       R0, 0
	MOVWF      SSD1306_DrawCircle_ddF_y_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_DrawCircle_ddF_y_L0+1
;ssd1306oled.c,565 :: 		int16_t x = 0;
	MOVLW      0
	MOVWF      SSD1306_DrawCircle_x_L0+0
	MOVLW      0
	MOVWF      SSD1306_DrawCircle_x_L0+1
;ssd1306oled.c,566 :: 		int16_t y = r;
	MOVF       FARG_SSD1306_DrawCircle_r+0, 0
	MOVWF      SSD1306_DrawCircle_y_L0+0
	MOVF       FARG_SSD1306_DrawCircle_r+1, 0
	MOVWF      SSD1306_DrawCircle_y_L0+1
;ssd1306oled.c,568 :: 		SSD1306_DrawPixel(x0  , y0 + r);
	MOVF       FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       FARG_SSD1306_DrawCircle_r+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,569 :: 		SSD1306_DrawPixel(x0  , y0 - r);
	MOVF       FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       FARG_SSD1306_DrawCircle_r+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,570 :: 		SSD1306_DrawPixel(x0 + r, y0);
	MOVF       FARG_SSD1306_DrawCircle_r+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,571 :: 		SSD1306_DrawPixel(x0 - r, y0);
	MOVF       FARG_SSD1306_DrawCircle_r+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,573 :: 		while (x < y) {
L_SSD1306_DrawCircle35:
	MOVLW      128
	XORWF      SSD1306_DrawCircle_x_L0+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      SSD1306_DrawCircle_y_L0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawCircle207
	MOVF       SSD1306_DrawCircle_y_L0+0, 0
	SUBWF      SSD1306_DrawCircle_x_L0+0, 0
L__SSD1306_DrawCircle207:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_DrawCircle36
;ssd1306oled.c,574 :: 		if (f >= 0) {
	MOVLW      128
	XORWF      SSD1306_DrawCircle_f_L0+1, 0
	MOVWF      R0
	MOVLW      128
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawCircle208
	MOVLW      0
	SUBWF      SSD1306_DrawCircle_f_L0+0, 0
L__SSD1306_DrawCircle208:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_DrawCircle37
;ssd1306oled.c,575 :: 		y--;
	MOVLW      1
	SUBWF      SSD1306_DrawCircle_y_L0+0, 1
	MOVLW      0
	SUBWFB     SSD1306_DrawCircle_y_L0+1, 1
;ssd1306oled.c,576 :: 		ddF_y += 2;
	MOVLW      2
	ADDWF      SSD1306_DrawCircle_ddF_y_L0+0, 0
	MOVWF      R0
	MOVLW      0
	ADDWFC     SSD1306_DrawCircle_ddF_y_L0+1, 0
	MOVWF      R1
	MOVF       R0, 0
	MOVWF      SSD1306_DrawCircle_ddF_y_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_DrawCircle_ddF_y_L0+1
;ssd1306oled.c,577 :: 		f += ddF_y;
	MOVF       R0, 0
	ADDWF      SSD1306_DrawCircle_f_L0+0, 1
	MOVF       R1, 0
	ADDWFC     SSD1306_DrawCircle_f_L0+1, 1
;ssd1306oled.c,578 :: 		}
L_SSD1306_DrawCircle37:
;ssd1306oled.c,579 :: 		x++;
	INCF       SSD1306_DrawCircle_x_L0+0, 1
	BTFSC      STATUS+0, 2
	INCF       SSD1306_DrawCircle_x_L0+1, 1
;ssd1306oled.c,580 :: 		ddF_x += 2;
	MOVLW      2
	ADDWF      SSD1306_DrawCircle_ddF_x_L0+0, 0
	MOVWF      R0
	MOVLW      0
	ADDWFC     SSD1306_DrawCircle_ddF_x_L0+1, 0
	MOVWF      R1
	MOVF       R0, 0
	MOVWF      SSD1306_DrawCircle_ddF_x_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_DrawCircle_ddF_x_L0+1
;ssd1306oled.c,581 :: 		f += ddF_x;
	MOVF       R0, 0
	ADDWF      SSD1306_DrawCircle_f_L0+0, 1
	MOVF       R1, 0
	ADDWFC     SSD1306_DrawCircle_f_L0+1, 1
;ssd1306oled.c,583 :: 		SSD1306_DrawPixel(x0 + x, y0 + y);
	MOVF       SSD1306_DrawCircle_x_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircle_y_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,584 :: 		SSD1306_DrawPixel(x0 - x, y0 + y);
	MOVF       SSD1306_DrawCircle_x_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircle_y_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,585 :: 		SSD1306_DrawPixel(x0 + x, y0 - y);
	MOVF       SSD1306_DrawCircle_x_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircle_y_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,586 :: 		SSD1306_DrawPixel(x0 - x, y0 - y);
	MOVF       SSD1306_DrawCircle_x_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircle_y_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,587 :: 		SSD1306_DrawPixel(x0 + y, y0 + x);
	MOVF       SSD1306_DrawCircle_y_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircle_x_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,588 :: 		SSD1306_DrawPixel(x0 - y, y0 + x);
	MOVF       SSD1306_DrawCircle_y_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircle_x_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,589 :: 		SSD1306_DrawPixel(x0 + y, y0 - x);
	MOVF       SSD1306_DrawCircle_y_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircle_x_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,590 :: 		SSD1306_DrawPixel(x0 - y, y0 - x);
	MOVF       SSD1306_DrawCircle_y_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircle_x_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,591 :: 		}
	GOTO       L_SSD1306_DrawCircle35
L_SSD1306_DrawCircle36:
;ssd1306oled.c,593 :: 		}
L_end_SSD1306_DrawCircle:
	RETURN
; end of _SSD1306_DrawCircle

_SSD1306_DrawCircleHelper:

;ssd1306oled.c,595 :: 		void SSD1306_DrawCircleHelper(int16_t x0, int16_t y0, int16_t r, uint8_t cornername) {
;ssd1306oled.c,596 :: 		int16_t f     = 1 - r;
	MOVF       FARG_SSD1306_DrawCircleHelper_r+0, 0
	SUBLW      1
	MOVWF      SSD1306_DrawCircleHelper_f_L0+0
	MOVF       FARG_SSD1306_DrawCircleHelper_r+1, 0
	BTFSS      STATUS+0, 0
	ADDLW      1
	CLRF       SSD1306_DrawCircleHelper_f_L0+1
	SUBWF      SSD1306_DrawCircleHelper_f_L0+1, 1
;ssd1306oled.c,597 :: 		int16_t ddF_x = 1;
	MOVLW      1
	MOVWF      SSD1306_DrawCircleHelper_ddF_x_L0+0
	MOVLW      0
	MOVWF      SSD1306_DrawCircleHelper_ddF_x_L0+1
;ssd1306oled.c,598 :: 		int16_t ddF_y = -2 * r;
	MOVLW      254
	MOVWF      R0
	MOVLW      255
	MOVWF      R1
	MOVF       FARG_SSD1306_DrawCircleHelper_r+0, 0
	MOVWF      R4
	MOVF       FARG_SSD1306_DrawCircleHelper_r+1, 0
	MOVWF      R5
	CALL       _Mul_16X16_U+0
	MOVF       R0, 0
	MOVWF      SSD1306_DrawCircleHelper_ddF_y_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_DrawCircleHelper_ddF_y_L0+1
;ssd1306oled.c,599 :: 		int16_t x     = 0;
	MOVLW      0
	MOVWF      SSD1306_DrawCircleHelper_x_L0+0
	MOVLW      0
	MOVWF      SSD1306_DrawCircleHelper_x_L0+1
;ssd1306oled.c,600 :: 		int16_t y     = r;
	MOVF       FARG_SSD1306_DrawCircleHelper_r+0, 0
	MOVWF      SSD1306_DrawCircleHelper_y_L0+0
	MOVF       FARG_SSD1306_DrawCircleHelper_r+1, 0
	MOVWF      SSD1306_DrawCircleHelper_y_L0+1
;ssd1306oled.c,602 :: 		while (x < y) {
L_SSD1306_DrawCircleHelper38:
	MOVLW      128
	XORWF      SSD1306_DrawCircleHelper_x_L0+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      SSD1306_DrawCircleHelper_y_L0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawCircleHelper210
	MOVF       SSD1306_DrawCircleHelper_y_L0+0, 0
	SUBWF      SSD1306_DrawCircleHelper_x_L0+0, 0
L__SSD1306_DrawCircleHelper210:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_DrawCircleHelper39
;ssd1306oled.c,603 :: 		if (f >= 0) {
	MOVLW      128
	XORWF      SSD1306_DrawCircleHelper_f_L0+1, 0
	MOVWF      R0
	MOVLW      128
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawCircleHelper211
	MOVLW      0
	SUBWF      SSD1306_DrawCircleHelper_f_L0+0, 0
L__SSD1306_DrawCircleHelper211:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_DrawCircleHelper40
;ssd1306oled.c,604 :: 		y--;
	MOVLW      1
	SUBWF      SSD1306_DrawCircleHelper_y_L0+0, 1
	MOVLW      0
	SUBWFB     SSD1306_DrawCircleHelper_y_L0+1, 1
;ssd1306oled.c,605 :: 		ddF_y += 2;
	MOVLW      2
	ADDWF      SSD1306_DrawCircleHelper_ddF_y_L0+0, 0
	MOVWF      R0
	MOVLW      0
	ADDWFC     SSD1306_DrawCircleHelper_ddF_y_L0+1, 0
	MOVWF      R1
	MOVF       R0, 0
	MOVWF      SSD1306_DrawCircleHelper_ddF_y_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_DrawCircleHelper_ddF_y_L0+1
;ssd1306oled.c,606 :: 		f     += ddF_y;
	MOVF       R0, 0
	ADDWF      SSD1306_DrawCircleHelper_f_L0+0, 1
	MOVF       R1, 0
	ADDWFC     SSD1306_DrawCircleHelper_f_L0+1, 1
;ssd1306oled.c,607 :: 		}
L_SSD1306_DrawCircleHelper40:
;ssd1306oled.c,608 :: 		x++;
	INCF       SSD1306_DrawCircleHelper_x_L0+0, 1
	BTFSC      STATUS+0, 2
	INCF       SSD1306_DrawCircleHelper_x_L0+1, 1
;ssd1306oled.c,609 :: 		ddF_x += 2;
	MOVLW      2
	ADDWF      SSD1306_DrawCircleHelper_ddF_x_L0+0, 0
	MOVWF      R0
	MOVLW      0
	ADDWFC     SSD1306_DrawCircleHelper_ddF_x_L0+1, 0
	MOVWF      R1
	MOVF       R0, 0
	MOVWF      SSD1306_DrawCircleHelper_ddF_x_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_DrawCircleHelper_ddF_x_L0+1
;ssd1306oled.c,610 :: 		f     += ddF_x;
	MOVF       R0, 0
	ADDWF      SSD1306_DrawCircleHelper_f_L0+0, 1
	MOVF       R1, 0
	ADDWFC     SSD1306_DrawCircleHelper_f_L0+1, 1
;ssd1306oled.c,611 :: 		if (cornername & 0x4) {
	BTFSS      FARG_SSD1306_DrawCircleHelper_cornername+0, 2
	GOTO       L_SSD1306_DrawCircleHelper41
;ssd1306oled.c,612 :: 		SSD1306_DrawPixel(x0 + x, y0 + y);
	MOVF       SSD1306_DrawCircleHelper_x_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircleHelper_y_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,613 :: 		SSD1306_DrawPixel(x0 + y, y0 + x);
	MOVF       SSD1306_DrawCircleHelper_y_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircleHelper_x_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,614 :: 		}
L_SSD1306_DrawCircleHelper41:
;ssd1306oled.c,615 :: 		if (cornername & 0x2) {
	BTFSS      FARG_SSD1306_DrawCircleHelper_cornername+0, 1
	GOTO       L_SSD1306_DrawCircleHelper42
;ssd1306oled.c,616 :: 		SSD1306_DrawPixel(x0 + x, y0 - y);
	MOVF       SSD1306_DrawCircleHelper_x_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircleHelper_y_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,617 :: 		SSD1306_DrawPixel(x0 + y, y0 - x);
	MOVF       SSD1306_DrawCircleHelper_y_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircleHelper_x_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,618 :: 		}
L_SSD1306_DrawCircleHelper42:
;ssd1306oled.c,619 :: 		if (cornername & 0x8) {
	BTFSS      FARG_SSD1306_DrawCircleHelper_cornername+0, 3
	GOTO       L_SSD1306_DrawCircleHelper43
;ssd1306oled.c,620 :: 		SSD1306_DrawPixel(x0 - y, y0 + x);
	MOVF       SSD1306_DrawCircleHelper_y_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircleHelper_x_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,621 :: 		SSD1306_DrawPixel(x0 - x, y0 + y);
	MOVF       SSD1306_DrawCircleHelper_x_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircleHelper_y_L0+0, 0
	ADDWF      FARG_SSD1306_DrawCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,622 :: 		}
L_SSD1306_DrawCircleHelper43:
;ssd1306oled.c,623 :: 		if (cornername & 0x1) {
	BTFSS      FARG_SSD1306_DrawCircleHelper_cornername+0, 0
	GOTO       L_SSD1306_DrawCircleHelper44
;ssd1306oled.c,624 :: 		SSD1306_DrawPixel(x0 - y, y0 - x);
	MOVF       SSD1306_DrawCircleHelper_y_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircleHelper_x_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,625 :: 		SSD1306_DrawPixel(x0 - x, y0 - y);
	MOVF       SSD1306_DrawCircleHelper_x_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_DrawCircleHelper_y_L0+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,626 :: 		}
L_SSD1306_DrawCircleHelper44:
;ssd1306oled.c,627 :: 		}
	GOTO       L_SSD1306_DrawCircleHelper38
L_SSD1306_DrawCircleHelper39:
;ssd1306oled.c,629 :: 		}
L_end_SSD1306_DrawCircleHelper:
	RETURN
; end of _SSD1306_DrawCircleHelper

_SSD1306_FillCircle:

;ssd1306oled.c,631 :: 		void SSD1306_FillCircle(int16_t x0, int16_t y0, int16_t r) {
;ssd1306oled.c,632 :: 		SSD1306_DrawFastVLine(x0, y0 - r, 2 * r + 1);
	MOVF       FARG_SSD1306_FillCircle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	MOVF       FARG_SSD1306_FillCircle_r+0, 0
	SUBWF      FARG_SSD1306_FillCircle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       FARG_SSD1306_FillCircle_r+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	LSLF       FARG_SSD1306_DrawFastVLine_h+0, 1
	INCF       FARG_SSD1306_DrawFastVLine_h+0, 1
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,633 :: 		SSD1306_FillCircleHelper(x0, y0, r, 3, 0);
	MOVF       FARG_SSD1306_FillCircle_x0+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_x0+0
	MOVF       FARG_SSD1306_FillCircle_x0+1, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_x0+1
	MOVF       FARG_SSD1306_FillCircle_y0+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_y0+0
	MOVF       FARG_SSD1306_FillCircle_y0+1, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_y0+1
	MOVF       FARG_SSD1306_FillCircle_r+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_r+0
	MOVF       FARG_SSD1306_FillCircle_r+1, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_r+1
	MOVLW      3
	MOVWF      FARG_SSD1306_FillCircleHelper_cornername+0
	CLRF       FARG_SSD1306_FillCircleHelper_delta+0
	CLRF       FARG_SSD1306_FillCircleHelper_delta+1
	CALL       _SSD1306_FillCircleHelper+0
;ssd1306oled.c,634 :: 		}
L_end_SSD1306_FillCircle:
	RETURN
; end of _SSD1306_FillCircle

_SSD1306_FillCircleHelper:

;ssd1306oled.c,637 :: 		void SSD1306_FillCircleHelper(int16_t x0, int16_t y0, int16_t r, uint8_t cornername, int16_t delta) {
;ssd1306oled.c,638 :: 		int16_t f     = 1 - r;
	MOVF       FARG_SSD1306_FillCircleHelper_r+0, 0
	SUBLW      1
	MOVWF      SSD1306_FillCircleHelper_f_L0+0
	MOVF       FARG_SSD1306_FillCircleHelper_r+1, 0
	BTFSS      STATUS+0, 0
	ADDLW      1
	CLRF       SSD1306_FillCircleHelper_f_L0+1
	SUBWF      SSD1306_FillCircleHelper_f_L0+1, 1
;ssd1306oled.c,639 :: 		int16_t ddF_x = 1;
	MOVLW      1
	MOVWF      SSD1306_FillCircleHelper_ddF_x_L0+0
	MOVLW      0
	MOVWF      SSD1306_FillCircleHelper_ddF_x_L0+1
;ssd1306oled.c,640 :: 		int16_t ddF_y = -2 * r;
	MOVLW      254
	MOVWF      R0
	MOVLW      255
	MOVWF      R1
	MOVF       FARG_SSD1306_FillCircleHelper_r+0, 0
	MOVWF      R4
	MOVF       FARG_SSD1306_FillCircleHelper_r+1, 0
	MOVWF      R5
	CALL       _Mul_16X16_U+0
	MOVF       R0, 0
	MOVWF      SSD1306_FillCircleHelper_ddF_y_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_FillCircleHelper_ddF_y_L0+1
;ssd1306oled.c,641 :: 		int16_t x     = 0;
	MOVLW      0
	MOVWF      SSD1306_FillCircleHelper_x_L0+0
	MOVLW      0
	MOVWF      SSD1306_FillCircleHelper_x_L0+1
;ssd1306oled.c,642 :: 		int16_t y     = r;
	MOVF       FARG_SSD1306_FillCircleHelper_r+0, 0
	MOVWF      SSD1306_FillCircleHelper_y_L0+0
	MOVF       FARG_SSD1306_FillCircleHelper_r+1, 0
	MOVWF      SSD1306_FillCircleHelper_y_L0+1
;ssd1306oled.c,644 :: 		while (x < y) {
L_SSD1306_FillCircleHelper45:
	MOVLW      128
	XORWF      SSD1306_FillCircleHelper_x_L0+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      SSD1306_FillCircleHelper_y_L0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillCircleHelper214
	MOVF       SSD1306_FillCircleHelper_y_L0+0, 0
	SUBWF      SSD1306_FillCircleHelper_x_L0+0, 0
L__SSD1306_FillCircleHelper214:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillCircleHelper46
;ssd1306oled.c,645 :: 		if (f >= 0) {
	MOVLW      128
	XORWF      SSD1306_FillCircleHelper_f_L0+1, 0
	MOVWF      R0
	MOVLW      128
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillCircleHelper215
	MOVLW      0
	SUBWF      SSD1306_FillCircleHelper_f_L0+0, 0
L__SSD1306_FillCircleHelper215:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_FillCircleHelper47
;ssd1306oled.c,646 :: 		y--;
	MOVLW      1
	SUBWF      SSD1306_FillCircleHelper_y_L0+0, 1
	MOVLW      0
	SUBWFB     SSD1306_FillCircleHelper_y_L0+1, 1
;ssd1306oled.c,647 :: 		ddF_y += 2;
	MOVLW      2
	ADDWF      SSD1306_FillCircleHelper_ddF_y_L0+0, 0
	MOVWF      R0
	MOVLW      0
	ADDWFC     SSD1306_FillCircleHelper_ddF_y_L0+1, 0
	MOVWF      R1
	MOVF       R0, 0
	MOVWF      SSD1306_FillCircleHelper_ddF_y_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_FillCircleHelper_ddF_y_L0+1
;ssd1306oled.c,648 :: 		f     += ddF_y;
	MOVF       R0, 0
	ADDWF      SSD1306_FillCircleHelper_f_L0+0, 1
	MOVF       R1, 0
	ADDWFC     SSD1306_FillCircleHelper_f_L0+1, 1
;ssd1306oled.c,649 :: 		}
L_SSD1306_FillCircleHelper47:
;ssd1306oled.c,650 :: 		x++;
	INCF       SSD1306_FillCircleHelper_x_L0+0, 1
	BTFSC      STATUS+0, 2
	INCF       SSD1306_FillCircleHelper_x_L0+1, 1
;ssd1306oled.c,651 :: 		ddF_x += 2;
	MOVLW      2
	ADDWF      SSD1306_FillCircleHelper_ddF_x_L0+0, 0
	MOVWF      R0
	MOVLW      0
	ADDWFC     SSD1306_FillCircleHelper_ddF_x_L0+1, 0
	MOVWF      R1
	MOVF       R0, 0
	MOVWF      SSD1306_FillCircleHelper_ddF_x_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_FillCircleHelper_ddF_x_L0+1
;ssd1306oled.c,652 :: 		f     += ddF_x;
	MOVF       R0, 0
	ADDWF      SSD1306_FillCircleHelper_f_L0+0, 1
	MOVF       R1, 0
	ADDWFC     SSD1306_FillCircleHelper_f_L0+1, 1
;ssd1306oled.c,654 :: 		if (cornername & 0x01) {
	BTFSS      FARG_SSD1306_FillCircleHelper_cornername+0, 0
	GOTO       L_SSD1306_FillCircleHelper48
;ssd1306oled.c,655 :: 		SSD1306_DrawFastVLine(x0 + x, y0 - y, 2 * y + 1 + delta);
	MOVF       SSD1306_FillCircleHelper_x_L0+0, 0
	ADDWF      FARG_SSD1306_FillCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	MOVF       SSD1306_FillCircleHelper_y_L0+0, 0
	SUBWF      FARG_SSD1306_FillCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       SSD1306_FillCircleHelper_y_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	LSLF       FARG_SSD1306_DrawFastVLine_h+0, 1
	INCF       FARG_SSD1306_DrawFastVLine_h+0, 1
	MOVF       FARG_SSD1306_FillCircleHelper_delta+0, 0
	ADDWF      FARG_SSD1306_DrawFastVLine_h+0, 1
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,656 :: 		SSD1306_DrawFastVLine(x0 + y, y0 - x, 2 * x + 1 + delta);
	MOVF       SSD1306_FillCircleHelper_y_L0+0, 0
	ADDWF      FARG_SSD1306_FillCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	MOVF       SSD1306_FillCircleHelper_x_L0+0, 0
	SUBWF      FARG_SSD1306_FillCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       SSD1306_FillCircleHelper_x_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	LSLF       FARG_SSD1306_DrawFastVLine_h+0, 1
	INCF       FARG_SSD1306_DrawFastVLine_h+0, 1
	MOVF       FARG_SSD1306_FillCircleHelper_delta+0, 0
	ADDWF      FARG_SSD1306_DrawFastVLine_h+0, 1
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,657 :: 		}
L_SSD1306_FillCircleHelper48:
;ssd1306oled.c,658 :: 		if (cornername & 0x02) {
	BTFSS      FARG_SSD1306_FillCircleHelper_cornername+0, 1
	GOTO       L_SSD1306_FillCircleHelper49
;ssd1306oled.c,659 :: 		SSD1306_DrawFastVLine(x0 - x, y0 - y, 2 * y + 1 + delta);
	MOVF       SSD1306_FillCircleHelper_x_L0+0, 0
	SUBWF      FARG_SSD1306_FillCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	MOVF       SSD1306_FillCircleHelper_y_L0+0, 0
	SUBWF      FARG_SSD1306_FillCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       SSD1306_FillCircleHelper_y_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	LSLF       FARG_SSD1306_DrawFastVLine_h+0, 1
	INCF       FARG_SSD1306_DrawFastVLine_h+0, 1
	MOVF       FARG_SSD1306_FillCircleHelper_delta+0, 0
	ADDWF      FARG_SSD1306_DrawFastVLine_h+0, 1
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,660 :: 		SSD1306_DrawFastVLine(x0 - y, y0 - x, 2 * x + 1 + delta);
	MOVF       SSD1306_FillCircleHelper_y_L0+0, 0
	SUBWF      FARG_SSD1306_FillCircleHelper_x0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	MOVF       SSD1306_FillCircleHelper_x_L0+0, 0
	SUBWF      FARG_SSD1306_FillCircleHelper_y0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       SSD1306_FillCircleHelper_x_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	LSLF       FARG_SSD1306_DrawFastVLine_h+0, 1
	INCF       FARG_SSD1306_DrawFastVLine_h+0, 1
	MOVF       FARG_SSD1306_FillCircleHelper_delta+0, 0
	ADDWF      FARG_SSD1306_DrawFastVLine_h+0, 1
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,661 :: 		}
L_SSD1306_FillCircleHelper49:
;ssd1306oled.c,662 :: 		}
	GOTO       L_SSD1306_FillCircleHelper45
L_SSD1306_FillCircleHelper46:
;ssd1306oled.c,664 :: 		}
L_end_SSD1306_FillCircleHelper:
	RETURN
; end of _SSD1306_FillCircleHelper

_SSD1306_DrawRect:

;ssd1306oled.c,667 :: 		void SSD1306_DrawRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h) {
;ssd1306oled.c,668 :: 		SSD1306_DrawFastHLine(x, y, w);
	MOVF       FARG_SSD1306_DrawRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_x+0
	MOVF       FARG_SSD1306_DrawRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_y+0
	MOVF       FARG_SSD1306_DrawRect_w+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_w+0
	CALL       _SSD1306_DrawFastHLine+0
;ssd1306oled.c,669 :: 		SSD1306_DrawFastHLine(x, y + h - 1, w);
	MOVF       FARG_SSD1306_DrawRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_x+0
	MOVF       FARG_SSD1306_DrawRect_h+0, 0
	ADDWF      FARG_SSD1306_DrawRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_y+0
	DECF       FARG_SSD1306_DrawFastHLine_y+0, 1
	MOVF       FARG_SSD1306_DrawRect_w+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_w+0
	CALL       _SSD1306_DrawFastHLine+0
;ssd1306oled.c,670 :: 		SSD1306_DrawFastVLine(x, y, h);
	MOVF       FARG_SSD1306_DrawRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	MOVF       FARG_SSD1306_DrawRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       FARG_SSD1306_DrawRect_h+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,671 :: 		SSD1306_DrawFastVLine(x + w - 1, y, h);
	MOVF       FARG_SSD1306_DrawRect_w+0, 0
	ADDWF      FARG_SSD1306_DrawRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	DECF       FARG_SSD1306_DrawFastVLine_x+0, 1
	MOVF       FARG_SSD1306_DrawRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       FARG_SSD1306_DrawRect_h+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,672 :: 		}
L_end_SSD1306_DrawRect:
	RETURN
; end of _SSD1306_DrawRect

_SSD1306_DrawRoundRect:

;ssd1306oled.c,675 :: 		void SSD1306_DrawRoundRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h, uint8_t r) {
;ssd1306oled.c,677 :: 		SSD1306_DrawFastHLine(x + r, y, w - 2 * r); // Top
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_x+0
	MOVF       FARG_SSD1306_DrawRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_y+0
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	MOVWF      R0
	LSLF       R0, 1
	MOVF       R0, 0
	SUBWF      FARG_SSD1306_DrawRoundRect_w+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_w+0
	CALL       _SSD1306_DrawFastHLine+0
;ssd1306oled.c,678 :: 		SSD1306_DrawFastHLine(x + r, y + h - 1, w - 2 * r); // Bottom
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_x+0
	MOVF       FARG_SSD1306_DrawRoundRect_h+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_y+0
	DECF       FARG_SSD1306_DrawFastHLine_y+0, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	MOVWF      R0
	LSLF       R0, 1
	MOVF       R0, 0
	SUBWF      FARG_SSD1306_DrawRoundRect_w+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_w+0
	CALL       _SSD1306_DrawFastHLine+0
;ssd1306oled.c,679 :: 		SSD1306_DrawFastVLine(x, y + r, h - 2 * r); // Left
	MOVF       FARG_SSD1306_DrawRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	MOVWF      R0
	LSLF       R0, 1
	MOVF       R0, 0
	SUBWF      FARG_SSD1306_DrawRoundRect_h+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,680 :: 		SSD1306_DrawFastVLine(x + w - 1, y + r, h - 2 * r); // Right
	MOVF       FARG_SSD1306_DrawRoundRect_w+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_x+0
	DECF       FARG_SSD1306_DrawFastVLine_x+0, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_y+0
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	MOVWF      R0
	LSLF       R0, 1
	MOVF       R0, 0
	SUBWF      FARG_SSD1306_DrawRoundRect_h+0, 0
	MOVWF      FARG_SSD1306_DrawFastVLine_h+0
	CALL       _SSD1306_DrawFastVLine+0
;ssd1306oled.c,682 :: 		SSD1306_DrawCircleHelper(x + r, y + r, r, 1);
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_x0+0
	CLRF       FARG_SSD1306_DrawCircleHelper_x0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawCircleHelper_x0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_y0+0
	CLRF       FARG_SSD1306_DrawCircleHelper_y0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawCircleHelper_y0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_r+0
	CLRF       FARG_SSD1306_DrawCircleHelper_r+1
	MOVLW      1
	MOVWF      FARG_SSD1306_DrawCircleHelper_cornername+0
	CALL       _SSD1306_DrawCircleHelper+0
;ssd1306oled.c,683 :: 		SSD1306_DrawCircleHelper(x + w - r - 1, y + r, r, 2);
	MOVF       FARG_SSD1306_DrawRoundRect_w+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_x0+0
	CLRF       FARG_SSD1306_DrawCircleHelper_x0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawCircleHelper_x0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_x0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawCircleHelper_x0+1, 1
	MOVLW      1
	SUBWF      FARG_SSD1306_DrawCircleHelper_x0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawCircleHelper_x0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_y0+0
	CLRF       FARG_SSD1306_DrawCircleHelper_y0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawCircleHelper_y0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_r+0
	CLRF       FARG_SSD1306_DrawCircleHelper_r+1
	MOVLW      2
	MOVWF      FARG_SSD1306_DrawCircleHelper_cornername+0
	CALL       _SSD1306_DrawCircleHelper+0
;ssd1306oled.c,684 :: 		SSD1306_DrawCircleHelper(x + w - r - 1, y + h - r - 1, r, 4);
	MOVF       FARG_SSD1306_DrawRoundRect_w+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_x0+0
	CLRF       FARG_SSD1306_DrawCircleHelper_x0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawCircleHelper_x0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_x0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawCircleHelper_x0+1, 1
	MOVLW      1
	SUBWF      FARG_SSD1306_DrawCircleHelper_x0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawCircleHelper_x0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_h+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_y0+0
	CLRF       FARG_SSD1306_DrawCircleHelper_y0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawCircleHelper_y0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_y0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawCircleHelper_y0+1, 1
	MOVLW      1
	SUBWF      FARG_SSD1306_DrawCircleHelper_y0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawCircleHelper_y0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_r+0
	CLRF       FARG_SSD1306_DrawCircleHelper_r+1
	MOVLW      4
	MOVWF      FARG_SSD1306_DrawCircleHelper_cornername+0
	CALL       _SSD1306_DrawCircleHelper+0
;ssd1306oled.c,685 :: 		SSD1306_DrawCircleHelper(x + r, y + h - r - 1, r, 8);
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_x0+0
	CLRF       FARG_SSD1306_DrawCircleHelper_x0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawCircleHelper_x0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_h+0, 0
	ADDWF      FARG_SSD1306_DrawRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_y0+0
	CLRF       FARG_SSD1306_DrawCircleHelper_y0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_DrawCircleHelper_y0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	SUBWF      FARG_SSD1306_DrawCircleHelper_y0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawCircleHelper_y0+1, 1
	MOVLW      1
	SUBWF      FARG_SSD1306_DrawCircleHelper_y0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_DrawCircleHelper_y0+1, 1
	MOVF       FARG_SSD1306_DrawRoundRect_r+0, 0
	MOVWF      FARG_SSD1306_DrawCircleHelper_r+0
	CLRF       FARG_SSD1306_DrawCircleHelper_r+1
	MOVLW      8
	MOVWF      FARG_SSD1306_DrawCircleHelper_cornername+0
	CALL       _SSD1306_DrawCircleHelper+0
;ssd1306oled.c,686 :: 		}
L_end_SSD1306_DrawRoundRect:
	RETURN
; end of _SSD1306_DrawRoundRect

_SSD1306_FillRoundRect:

;ssd1306oled.c,689 :: 		void SSD1306_FillRoundRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h, uint8_t r) {
;ssd1306oled.c,691 :: 		SSD1306_FillRect(x + r, y, w - 2 * r, h);
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_FillRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_FillRect_x+0
	MOVF       FARG_SSD1306_FillRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_FillRect_y+0
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	MOVWF      R0
	LSLF       R0, 1
	MOVF       R0, 0
	SUBWF      FARG_SSD1306_FillRoundRect_w+0, 0
	MOVWF      FARG_SSD1306_FillRect_w+0
	MOVF       FARG_SSD1306_FillRoundRect_h+0, 0
	MOVWF      FARG_SSD1306_FillRect_h+0
	CALL       _SSD1306_FillRect+0
;ssd1306oled.c,693 :: 		SSD1306_FillCircleHelper(x + w - r - 1, y + r, r, 1, h - 2 * r - 1);
	MOVF       FARG_SSD1306_FillRoundRect_w+0, 0
	ADDWF      FARG_SSD1306_FillRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_x0+0
	CLRF       FARG_SSD1306_FillCircleHelper_x0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_FillCircleHelper_x0+1, 1
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	SUBWF      FARG_SSD1306_FillCircleHelper_x0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_FillCircleHelper_x0+1, 1
	MOVLW      1
	SUBWF      FARG_SSD1306_FillCircleHelper_x0+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_FillCircleHelper_x0+1, 1
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_FillRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_y0+0
	CLRF       FARG_SSD1306_FillCircleHelper_y0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_FillCircleHelper_y0+1, 1
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_r+0
	CLRF       FARG_SSD1306_FillCircleHelper_r+1
	MOVLW      1
	MOVWF      FARG_SSD1306_FillCircleHelper_cornername+0
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	MOVWF      R0
	CLRF       R1
	LSLF       R0, 1
	RLF        R1, 1
	MOVF       R0, 0
	SUBWF      FARG_SSD1306_FillRoundRect_h+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_delta+0
	MOVF       R1, 0
	BTFSS      STATUS+0, 0
	ADDLW      1
	CLRF       FARG_SSD1306_FillCircleHelper_delta+1
	SUBWF      FARG_SSD1306_FillCircleHelper_delta+1, 1
	MOVLW      1
	SUBWF      FARG_SSD1306_FillCircleHelper_delta+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_FillCircleHelper_delta+1, 1
	CALL       _SSD1306_FillCircleHelper+0
;ssd1306oled.c,694 :: 		SSD1306_FillCircleHelper(x + r        , y + r, r, 2, h - 2 * r - 1);
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_FillRoundRect_x+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_x0+0
	CLRF       FARG_SSD1306_FillCircleHelper_x0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_FillCircleHelper_x0+1, 1
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	ADDWF      FARG_SSD1306_FillRoundRect_y+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_y0+0
	CLRF       FARG_SSD1306_FillCircleHelper_y0+1
	MOVLW      0
	ADDWFC     FARG_SSD1306_FillCircleHelper_y0+1, 1
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_r+0
	CLRF       FARG_SSD1306_FillCircleHelper_r+1
	MOVLW      2
	MOVWF      FARG_SSD1306_FillCircleHelper_cornername+0
	MOVF       FARG_SSD1306_FillRoundRect_r+0, 0
	MOVWF      R0
	CLRF       R1
	LSLF       R0, 1
	RLF        R1, 1
	MOVF       R0, 0
	SUBWF      FARG_SSD1306_FillRoundRect_h+0, 0
	MOVWF      FARG_SSD1306_FillCircleHelper_delta+0
	MOVF       R1, 0
	BTFSS      STATUS+0, 0
	ADDLW      1
	CLRF       FARG_SSD1306_FillCircleHelper_delta+1
	SUBWF      FARG_SSD1306_FillCircleHelper_delta+1, 1
	MOVLW      1
	SUBWF      FARG_SSD1306_FillCircleHelper_delta+0, 1
	MOVLW      0
	SUBWFB     FARG_SSD1306_FillCircleHelper_delta+1, 1
	CALL       _SSD1306_FillCircleHelper+0
;ssd1306oled.c,695 :: 		}
L_end_SSD1306_FillRoundRect:
	RETURN
; end of _SSD1306_FillRoundRect

_SSD1306_DrawTriangle:

;ssd1306oled.c,698 :: 		void SSD1306_DrawTriangle(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, uint8_t x2, uint8_t y2) {
;ssd1306oled.c,699 :: 		SSD1306_DrawLine(x0, y0, x1, y1);
	MOVF       FARG_SSD1306_DrawTriangle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x0+0
	CLRF       FARG_SSD1306_DrawLine_x0+1
	MOVF       FARG_SSD1306_DrawTriangle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y0+0
	CLRF       FARG_SSD1306_DrawLine_y0+1
	MOVF       FARG_SSD1306_DrawTriangle_x1+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x1+0
	CLRF       FARG_SSD1306_DrawLine_x1+1
	MOVF       FARG_SSD1306_DrawTriangle_y1+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y1+0
	CLRF       FARG_SSD1306_DrawLine_y1+1
	CALL       _SSD1306_DrawLine+0
;ssd1306oled.c,700 :: 		SSD1306_DrawLine(x1, y1, x2, y2);
	MOVF       FARG_SSD1306_DrawTriangle_x1+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x0+0
	CLRF       FARG_SSD1306_DrawLine_x0+1
	MOVF       FARG_SSD1306_DrawTriangle_y1+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y0+0
	CLRF       FARG_SSD1306_DrawLine_y0+1
	MOVF       FARG_SSD1306_DrawTriangle_x2+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x1+0
	CLRF       FARG_SSD1306_DrawLine_x1+1
	MOVF       FARG_SSD1306_DrawTriangle_y2+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y1+0
	CLRF       FARG_SSD1306_DrawLine_y1+1
	CALL       _SSD1306_DrawLine+0
;ssd1306oled.c,701 :: 		SSD1306_DrawLine(x2, y2, x0, y0);
	MOVF       FARG_SSD1306_DrawTriangle_x2+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x0+0
	CLRF       FARG_SSD1306_DrawLine_x0+1
	MOVF       FARG_SSD1306_DrawTriangle_y2+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y0+0
	CLRF       FARG_SSD1306_DrawLine_y0+1
	MOVF       FARG_SSD1306_DrawTriangle_x0+0, 0
	MOVWF      FARG_SSD1306_DrawLine_x1+0
	CLRF       FARG_SSD1306_DrawLine_x1+1
	MOVF       FARG_SSD1306_DrawTriangle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawLine_y1+0
	CLRF       FARG_SSD1306_DrawLine_y1+1
	CALL       _SSD1306_DrawLine+0
;ssd1306oled.c,702 :: 		}
L_end_SSD1306_DrawTriangle:
	RETURN
; end of _SSD1306_DrawTriangle

_SSD1306_FillTriangle:

;ssd1306oled.c,705 :: 		void SSD1306_FillTriangle(int16_t x0, int16_t y0, int16_t x1, int16_t y1, int16_t x2, int16_t y2) {
;ssd1306oled.c,707 :: 		dx01 = x1 - x0,
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_x1+0, 0
	MOVWF      SSD1306_FillTriangle_dx01_L0+0
	MOVF       FARG_SSD1306_FillTriangle_x0+1, 0
	SUBWFB     FARG_SSD1306_FillTriangle_x1+1, 0
	MOVWF      SSD1306_FillTriangle_dx01_L0+1
;ssd1306oled.c,708 :: 		dy01 = y1 - y0,
	MOVF       FARG_SSD1306_FillTriangle_y0+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_y1+0, 0
	MOVWF      SSD1306_FillTriangle_dy01_L0+0
	MOVF       FARG_SSD1306_FillTriangle_y0+1, 0
	SUBWFB     FARG_SSD1306_FillTriangle_y1+1, 0
	MOVWF      SSD1306_FillTriangle_dy01_L0+1
;ssd1306oled.c,709 :: 		dx02 = x2 - x0,
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_x2+0, 0
	MOVWF      SSD1306_FillTriangle_dx02_L0+0
	MOVF       FARG_SSD1306_FillTriangle_x0+1, 0
	SUBWFB     FARG_SSD1306_FillTriangle_x2+1, 0
	MOVWF      SSD1306_FillTriangle_dx02_L0+1
;ssd1306oled.c,710 :: 		dy02 = y2 - y0,
	MOVF       FARG_SSD1306_FillTriangle_y0+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_y2+0, 0
	MOVWF      SSD1306_FillTriangle_dy02_L0+0
	MOVF       FARG_SSD1306_FillTriangle_y0+1, 0
	SUBWFB     FARG_SSD1306_FillTriangle_y2+1, 0
	MOVWF      SSD1306_FillTriangle_dy02_L0+1
;ssd1306oled.c,711 :: 		dx12 = x2 - x1,
	MOVF       FARG_SSD1306_FillTriangle_x1+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_x2+0, 0
	MOVWF      SSD1306_FillTriangle_dx12_L0+0
	MOVF       FARG_SSD1306_FillTriangle_x1+1, 0
	SUBWFB     FARG_SSD1306_FillTriangle_x2+1, 0
	MOVWF      SSD1306_FillTriangle_dx12_L0+1
;ssd1306oled.c,712 :: 		dy12 = y2 - y1;
	MOVF       FARG_SSD1306_FillTriangle_y1+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_y2+0, 0
	MOVWF      SSD1306_FillTriangle_dy12_L0+0
	MOVF       FARG_SSD1306_FillTriangle_y1+1, 0
	SUBWFB     FARG_SSD1306_FillTriangle_y2+1, 0
	MOVWF      SSD1306_FillTriangle_dy12_L0+1
;ssd1306oled.c,713 :: 		int32_t  sa   = 0, sb   = 0;
	CLRF       SSD1306_FillTriangle_sa_L0+0
	CLRF       SSD1306_FillTriangle_sa_L0+1
	CLRF       SSD1306_FillTriangle_sa_L0+2
	CLRF       SSD1306_FillTriangle_sa_L0+3
	CLRF       SSD1306_FillTriangle_sb_L0+0
	CLRF       SSD1306_FillTriangle_sb_L0+1
	CLRF       SSD1306_FillTriangle_sb_L0+2
	CLRF       SSD1306_FillTriangle_sb_L0+3
;ssd1306oled.c,715 :: 		if (y0 > y1) {
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_y1+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_y0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle221
	MOVF       FARG_SSD1306_FillTriangle_y0+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_y1+0, 0
L__SSD1306_FillTriangle221:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle50
;ssd1306oled.c,716 :: 		ssd1306_swap(y0, y1); ssd1306_swap(x0, x1);
	MOVF       FARG_SSD1306_FillTriangle_y0+0, 0
	MOVWF      SSD1306_FillTriangle_t_L2+0
	MOVF       FARG_SSD1306_FillTriangle_y0+1, 0
	MOVWF      SSD1306_FillTriangle_t_L2+1
	MOVF       FARG_SSD1306_FillTriangle_y1+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_y0+0
	MOVF       FARG_SSD1306_FillTriangle_y1+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_y0+1
	MOVF       SSD1306_FillTriangle_t_L2+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_y1+0
	MOVF       SSD1306_FillTriangle_t_L2+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_y1+1
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2+0
	MOVF       FARG_SSD1306_FillTriangle_x0+1, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2+1
	MOVF       FARG_SSD1306_FillTriangle_x1+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_x0+0
	MOVF       FARG_SSD1306_FillTriangle_x1+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_x0+1
	MOVF       SSD1306_FillTriangle_t_L2_L2+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_x1+0
	MOVF       SSD1306_FillTriangle_t_L2_L2+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_x1+1
;ssd1306oled.c,717 :: 		}
L_SSD1306_FillTriangle50:
;ssd1306oled.c,718 :: 		if (y1 > y2) {
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_y2+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_y1+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle222
	MOVF       FARG_SSD1306_FillTriangle_y1+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_y2+0, 0
L__SSD1306_FillTriangle222:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle51
;ssd1306oled.c,719 :: 		ssd1306_swap(y2, y1); ssd1306_swap(x2, x1);
	MOVF       FARG_SSD1306_FillTriangle_y2+0, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2+0
	MOVF       FARG_SSD1306_FillTriangle_y2+1, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2+1
	MOVF       FARG_SSD1306_FillTriangle_y1+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_y2+0
	MOVF       FARG_SSD1306_FillTriangle_y1+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_y2+1
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_y1+0
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_y1+1
	MOVF       FARG_SSD1306_FillTriangle_x2+0, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2+0
	MOVF       FARG_SSD1306_FillTriangle_x2+1, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2+1
	MOVF       FARG_SSD1306_FillTriangle_x1+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_x2+0
	MOVF       FARG_SSD1306_FillTriangle_x1+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_x2+1
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_x1+0
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_x1+1
;ssd1306oled.c,720 :: 		}
L_SSD1306_FillTriangle51:
;ssd1306oled.c,721 :: 		if (y0 > y1) {
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_y1+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_y0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle223
	MOVF       FARG_SSD1306_FillTriangle_y0+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_y1+0, 0
L__SSD1306_FillTriangle223:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle52
;ssd1306oled.c,722 :: 		ssd1306_swap(y0, y1); ssd1306_swap(x0, x1);
	MOVF       FARG_SSD1306_FillTriangle_y0+0, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2_L2+0
	MOVF       FARG_SSD1306_FillTriangle_y0+1, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2_L2+1
	MOVF       FARG_SSD1306_FillTriangle_y1+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_y0+0
	MOVF       FARG_SSD1306_FillTriangle_y1+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_y0+1
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_y1+0
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_y1+1
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2+0
	MOVF       FARG_SSD1306_FillTriangle_x0+1, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2+1
	MOVF       FARG_SSD1306_FillTriangle_x1+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_x0+0
	MOVF       FARG_SSD1306_FillTriangle_x1+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_x0+1
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2+0, 0
	MOVWF      FARG_SSD1306_FillTriangle_x1+0
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2+1, 0
	MOVWF      FARG_SSD1306_FillTriangle_x1+1
;ssd1306oled.c,723 :: 		}
L_SSD1306_FillTriangle52:
;ssd1306oled.c,725 :: 		if(y0 == y2) { // Handle awkward all-on-same-line case as its own thing
	MOVF       FARG_SSD1306_FillTriangle_y0+1, 0
	XORWF      FARG_SSD1306_FillTriangle_y2+1, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle224
	MOVF       FARG_SSD1306_FillTriangle_y2+0, 0
	XORWF      FARG_SSD1306_FillTriangle_y0+0, 0
L__SSD1306_FillTriangle224:
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_FillTriangle53
;ssd1306oled.c,726 :: 		a = b = x0;
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	MOVWF      SSD1306_FillTriangle_b_L0+0
	MOVF       FARG_SSD1306_FillTriangle_x0+1, 0
	MOVWF      SSD1306_FillTriangle_b_L0+1
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	MOVWF      SSD1306_FillTriangle_a_L0+0
	MOVF       FARG_SSD1306_FillTriangle_x0+1, 0
	MOVWF      SSD1306_FillTriangle_a_L0+1
;ssd1306oled.c,727 :: 		if(x1 < a)      a = x1;
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_x1+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_x0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle225
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_x1+0, 0
L__SSD1306_FillTriangle225:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle54
	MOVF       FARG_SSD1306_FillTriangle_x1+0, 0
	MOVWF      SSD1306_FillTriangle_a_L0+0
	MOVF       FARG_SSD1306_FillTriangle_x1+1, 0
	MOVWF      SSD1306_FillTriangle_a_L0+1
	GOTO       L_SSD1306_FillTriangle55
L_SSD1306_FillTriangle54:
;ssd1306oled.c,728 :: 		else if(x1 > b) b = x1;
	MOVLW      128
	XORWF      SSD1306_FillTriangle_b_L0+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_x1+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle226
	MOVF       FARG_SSD1306_FillTriangle_x1+0, 0
	SUBWF      SSD1306_FillTriangle_b_L0+0, 0
L__SSD1306_FillTriangle226:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle56
	MOVF       FARG_SSD1306_FillTriangle_x1+0, 0
	MOVWF      SSD1306_FillTriangle_b_L0+0
	MOVF       FARG_SSD1306_FillTriangle_x1+1, 0
	MOVWF      SSD1306_FillTriangle_b_L0+1
L_SSD1306_FillTriangle56:
L_SSD1306_FillTriangle55:
;ssd1306oled.c,729 :: 		if(x2 < a)      a = x2;
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_x2+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      SSD1306_FillTriangle_a_L0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle227
	MOVF       SSD1306_FillTriangle_a_L0+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_x2+0, 0
L__SSD1306_FillTriangle227:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle57
	MOVF       FARG_SSD1306_FillTriangle_x2+0, 0
	MOVWF      SSD1306_FillTriangle_a_L0+0
	MOVF       FARG_SSD1306_FillTriangle_x2+1, 0
	MOVWF      SSD1306_FillTriangle_a_L0+1
	GOTO       L_SSD1306_FillTriangle58
L_SSD1306_FillTriangle57:
;ssd1306oled.c,730 :: 		else if(x2 > b) b = x2;
	MOVLW      128
	XORWF      SSD1306_FillTriangle_b_L0+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_x2+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle228
	MOVF       FARG_SSD1306_FillTriangle_x2+0, 0
	SUBWF      SSD1306_FillTriangle_b_L0+0, 0
L__SSD1306_FillTriangle228:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle59
	MOVF       FARG_SSD1306_FillTriangle_x2+0, 0
	MOVWF      SSD1306_FillTriangle_b_L0+0
	MOVF       FARG_SSD1306_FillTriangle_x2+1, 0
	MOVWF      SSD1306_FillTriangle_b_L0+1
L_SSD1306_FillTriangle59:
L_SSD1306_FillTriangle58:
;ssd1306oled.c,731 :: 		SSD1306_DrawFastHLine(a, y0, b - a + 1);
	MOVF       SSD1306_FillTriangle_a_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_x+0
	MOVF       FARG_SSD1306_FillTriangle_y0+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_y+0
	MOVF       SSD1306_FillTriangle_a_L0+0, 0
	SUBWF      SSD1306_FillTriangle_b_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_w+0
	INCF       FARG_SSD1306_DrawFastHLine_w+0, 1
	CALL       _SSD1306_DrawFastHLine+0
;ssd1306oled.c,732 :: 		return;
	GOTO       L_end_SSD1306_FillTriangle
;ssd1306oled.c,733 :: 		}
L_SSD1306_FillTriangle53:
;ssd1306oled.c,735 :: 		if(y1 == y2) last = y1;   // Include y1 scanline
	MOVF       FARG_SSD1306_FillTriangle_y1+1, 0
	XORWF      FARG_SSD1306_FillTriangle_y2+1, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle229
	MOVF       FARG_SSD1306_FillTriangle_y2+0, 0
	XORWF      FARG_SSD1306_FillTriangle_y1+0, 0
L__SSD1306_FillTriangle229:
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_FillTriangle60
	MOVF       FARG_SSD1306_FillTriangle_y1+0, 0
	MOVWF      SSD1306_FillTriangle_last_L0+0
	MOVF       FARG_SSD1306_FillTriangle_y1+1, 0
	MOVWF      SSD1306_FillTriangle_last_L0+1
	GOTO       L_SSD1306_FillTriangle61
L_SSD1306_FillTriangle60:
;ssd1306oled.c,736 :: 		else         last = y1 - 1; // Skip it
	MOVLW      1
	SUBWF      FARG_SSD1306_FillTriangle_y1+0, 0
	MOVWF      SSD1306_FillTriangle_last_L0+0
	MOVLW      0
	SUBWFB     FARG_SSD1306_FillTriangle_y1+1, 0
	MOVWF      SSD1306_FillTriangle_last_L0+1
L_SSD1306_FillTriangle61:
;ssd1306oled.c,738 :: 		for(y = y0; y <= last; y++) {
	MOVF       FARG_SSD1306_FillTriangle_y0+0, 0
	MOVWF      SSD1306_FillTriangle_y_L0+0
	MOVF       FARG_SSD1306_FillTriangle_y0+1, 0
	MOVWF      SSD1306_FillTriangle_y_L0+1
L_SSD1306_FillTriangle62:
	MOVLW      128
	XORWF      SSD1306_FillTriangle_last_L0+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      SSD1306_FillTriangle_y_L0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle230
	MOVF       SSD1306_FillTriangle_y_L0+0, 0
	SUBWF      SSD1306_FillTriangle_last_L0+0, 0
L__SSD1306_FillTriangle230:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle63
;ssd1306oled.c,739 :: 		a   = x0 + sa / dy01;
	MOVF       SSD1306_FillTriangle_dy01_L0+0, 0
	MOVWF      R4
	MOVF       SSD1306_FillTriangle_dy01_L0+1, 0
	MOVWF      R5
	MOVLW      0
	BTFSC      R5, 7
	MOVLW      255
	MOVWF      R6
	MOVWF      R7
	MOVF       SSD1306_FillTriangle_sa_L0+0, 0
	MOVWF      R0
	MOVF       SSD1306_FillTriangle_sa_L0+1, 0
	MOVWF      R1
	MOVF       SSD1306_FillTriangle_sa_L0+2, 0
	MOVWF      R2
	MOVF       SSD1306_FillTriangle_sa_L0+3, 0
	MOVWF      R3
	CALL       _Div_32x32_S+0
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	ADDWF      R0, 0
	MOVWF      FLOC__SSD1306_FillTriangle+0
	MOVF       FARG_SSD1306_FillTriangle_x0+1, 0
	ADDWFC     R1, 0
	MOVWF      FLOC__SSD1306_FillTriangle+1
	MOVF       FLOC__SSD1306_FillTriangle+0, 0
	MOVWF      SSD1306_FillTriangle_a_L0+0
	MOVF       FLOC__SSD1306_FillTriangle+1, 0
	MOVWF      SSD1306_FillTriangle_a_L0+1
;ssd1306oled.c,740 :: 		b   = x0 + sb / dy02;
	MOVF       SSD1306_FillTriangle_dy02_L0+0, 0
	MOVWF      R4
	MOVF       SSD1306_FillTriangle_dy02_L0+1, 0
	MOVWF      R5
	MOVLW      0
	BTFSC      R5, 7
	MOVLW      255
	MOVWF      R6
	MOVWF      R7
	MOVF       SSD1306_FillTriangle_sb_L0+0, 0
	MOVWF      R0
	MOVF       SSD1306_FillTriangle_sb_L0+1, 0
	MOVWF      R1
	MOVF       SSD1306_FillTriangle_sb_L0+2, 0
	MOVWF      R2
	MOVF       SSD1306_FillTriangle_sb_L0+3, 0
	MOVWF      R3
	CALL       _Div_32x32_S+0
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	ADDWF      R0, 0
	MOVWF      R4
	MOVF       FARG_SSD1306_FillTriangle_x0+1, 0
	ADDWFC     R1, 0
	MOVWF      R5
	MOVF       R4, 0
	MOVWF      SSD1306_FillTriangle_b_L0+0
	MOVF       R5, 0
	MOVWF      SSD1306_FillTriangle_b_L0+1
;ssd1306oled.c,741 :: 		sa += dx01;
	MOVF       SSD1306_FillTriangle_dx01_L0+0, 0
	ADDWF      SSD1306_FillTriangle_sa_L0+0, 1
	MOVF       SSD1306_FillTriangle_dx01_L0+1, 0
	ADDWFC     SSD1306_FillTriangle_sa_L0+1, 1
	MOVLW      0
	BTFSC      SSD1306_FillTriangle_dx01_L0+1, 7
	MOVLW      255
	ADDWFC     SSD1306_FillTriangle_sa_L0+2, 1
	ADDWFC     SSD1306_FillTriangle_sa_L0+3, 1
;ssd1306oled.c,742 :: 		sb += dx02;
	MOVF       SSD1306_FillTriangle_dx02_L0+0, 0
	ADDWF      SSD1306_FillTriangle_sb_L0+0, 1
	MOVF       SSD1306_FillTriangle_dx02_L0+1, 0
	ADDWFC     SSD1306_FillTriangle_sb_L0+1, 1
	MOVLW      0
	BTFSC      SSD1306_FillTriangle_dx02_L0+1, 7
	MOVLW      255
	ADDWFC     SSD1306_FillTriangle_sb_L0+2, 1
	ADDWFC     SSD1306_FillTriangle_sb_L0+3, 1
;ssd1306oled.c,747 :: 		if(a > b) ssd1306_swap(a, b);
	MOVLW      128
	XORWF      R5, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FLOC__SSD1306_FillTriangle+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle231
	MOVF       FLOC__SSD1306_FillTriangle+0, 0
	SUBWF      R4, 0
L__SSD1306_FillTriangle231:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle65
	MOVF       SSD1306_FillTriangle_a_L0+0, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2+0
	MOVF       SSD1306_FillTriangle_a_L0+1, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2+1
	MOVF       SSD1306_FillTriangle_b_L0+0, 0
	MOVWF      SSD1306_FillTriangle_a_L0+0
	MOVF       SSD1306_FillTriangle_b_L0+1, 0
	MOVWF      SSD1306_FillTriangle_a_L0+1
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2+0, 0
	MOVWF      SSD1306_FillTriangle_b_L0+0
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2+1, 0
	MOVWF      SSD1306_FillTriangle_b_L0+1
L_SSD1306_FillTriangle65:
;ssd1306oled.c,748 :: 		SSD1306_DrawFastHLine(a, y, b - a + 1);
	MOVF       SSD1306_FillTriangle_a_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_x+0
	MOVF       SSD1306_FillTriangle_y_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_y+0
	MOVF       SSD1306_FillTriangle_a_L0+0, 0
	SUBWF      SSD1306_FillTriangle_b_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_w+0
	INCF       FARG_SSD1306_DrawFastHLine_w+0, 1
	CALL       _SSD1306_DrawFastHLine+0
;ssd1306oled.c,738 :: 		for(y = y0; y <= last; y++) {
	INCF       SSD1306_FillTriangle_y_L0+0, 1
	BTFSC      STATUS+0, 2
	INCF       SSD1306_FillTriangle_y_L0+1, 1
;ssd1306oled.c,749 :: 		}
	GOTO       L_SSD1306_FillTriangle62
L_SSD1306_FillTriangle63:
;ssd1306oled.c,753 :: 		sa = dx12 * (y - y1);
	MOVF       FARG_SSD1306_FillTriangle_y1+0, 0
	SUBWF      SSD1306_FillTriangle_y_L0+0, 0
	MOVWF      R0
	MOVF       FARG_SSD1306_FillTriangle_y1+1, 0
	SUBWFB     SSD1306_FillTriangle_y_L0+1, 0
	MOVWF      R1
	MOVF       SSD1306_FillTriangle_dx12_L0+0, 0
	MOVWF      R4
	MOVF       SSD1306_FillTriangle_dx12_L0+1, 0
	MOVWF      R5
	CALL       _Mul_16X16_U+0
	MOVF       R0, 0
	MOVWF      SSD1306_FillTriangle_sa_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_FillTriangle_sa_L0+1
	MOVLW      0
	BTFSC      SSD1306_FillTriangle_sa_L0+1, 7
	MOVLW      255
	MOVWF      SSD1306_FillTriangle_sa_L0+2
	MOVWF      SSD1306_FillTriangle_sa_L0+3
;ssd1306oled.c,754 :: 		sb = dx02 * (y - y0);
	MOVF       FARG_SSD1306_FillTriangle_y0+0, 0
	SUBWF      SSD1306_FillTriangle_y_L0+0, 0
	MOVWF      R0
	MOVF       FARG_SSD1306_FillTriangle_y0+1, 0
	SUBWFB     SSD1306_FillTriangle_y_L0+1, 0
	MOVWF      R1
	MOVF       SSD1306_FillTriangle_dx02_L0+0, 0
	MOVWF      R4
	MOVF       SSD1306_FillTriangle_dx02_L0+1, 0
	MOVWF      R5
	CALL       _Mul_16X16_U+0
	MOVF       R0, 0
	MOVWF      SSD1306_FillTriangle_sb_L0+0
	MOVF       R1, 0
	MOVWF      SSD1306_FillTriangle_sb_L0+1
	MOVLW      0
	BTFSC      SSD1306_FillTriangle_sb_L0+1, 7
	MOVLW      255
	MOVWF      SSD1306_FillTriangle_sb_L0+2
	MOVWF      SSD1306_FillTriangle_sb_L0+3
;ssd1306oled.c,755 :: 		for(; y <= y2; y++) {
L_SSD1306_FillTriangle66:
	MOVLW      128
	XORWF      FARG_SSD1306_FillTriangle_y2+1, 0
	MOVWF      R0
	MOVLW      128
	XORWF      SSD1306_FillTriangle_y_L0+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle232
	MOVF       SSD1306_FillTriangle_y_L0+0, 0
	SUBWF      FARG_SSD1306_FillTriangle_y2+0, 0
L__SSD1306_FillTriangle232:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle67
;ssd1306oled.c,756 :: 		a   = x1 + sa / dy12;
	MOVF       SSD1306_FillTriangle_dy12_L0+0, 0
	MOVWF      R4
	MOVF       SSD1306_FillTriangle_dy12_L0+1, 0
	MOVWF      R5
	MOVLW      0
	BTFSC      R5, 7
	MOVLW      255
	MOVWF      R6
	MOVWF      R7
	MOVF       SSD1306_FillTriangle_sa_L0+0, 0
	MOVWF      R0
	MOVF       SSD1306_FillTriangle_sa_L0+1, 0
	MOVWF      R1
	MOVF       SSD1306_FillTriangle_sa_L0+2, 0
	MOVWF      R2
	MOVF       SSD1306_FillTriangle_sa_L0+3, 0
	MOVWF      R3
	CALL       _Div_32x32_S+0
	MOVF       FARG_SSD1306_FillTriangle_x1+0, 0
	ADDWF      R0, 0
	MOVWF      FLOC__SSD1306_FillTriangle+0
	MOVF       FARG_SSD1306_FillTriangle_x1+1, 0
	ADDWFC     R1, 0
	MOVWF      FLOC__SSD1306_FillTriangle+1
	MOVF       FLOC__SSD1306_FillTriangle+0, 0
	MOVWF      SSD1306_FillTriangle_a_L0+0
	MOVF       FLOC__SSD1306_FillTriangle+1, 0
	MOVWF      SSD1306_FillTriangle_a_L0+1
;ssd1306oled.c,757 :: 		b   = x0 + sb / dy02;
	MOVF       SSD1306_FillTriangle_dy02_L0+0, 0
	MOVWF      R4
	MOVF       SSD1306_FillTriangle_dy02_L0+1, 0
	MOVWF      R5
	MOVLW      0
	BTFSC      R5, 7
	MOVLW      255
	MOVWF      R6
	MOVWF      R7
	MOVF       SSD1306_FillTriangle_sb_L0+0, 0
	MOVWF      R0
	MOVF       SSD1306_FillTriangle_sb_L0+1, 0
	MOVWF      R1
	MOVF       SSD1306_FillTriangle_sb_L0+2, 0
	MOVWF      R2
	MOVF       SSD1306_FillTriangle_sb_L0+3, 0
	MOVWF      R3
	CALL       _Div_32x32_S+0
	MOVF       FARG_SSD1306_FillTriangle_x0+0, 0
	ADDWF      R0, 0
	MOVWF      R4
	MOVF       FARG_SSD1306_FillTriangle_x0+1, 0
	ADDWFC     R1, 0
	MOVWF      R5
	MOVF       R4, 0
	MOVWF      SSD1306_FillTriangle_b_L0+0
	MOVF       R5, 0
	MOVWF      SSD1306_FillTriangle_b_L0+1
;ssd1306oled.c,758 :: 		sa += dx12;
	MOVF       SSD1306_FillTriangle_dx12_L0+0, 0
	ADDWF      SSD1306_FillTriangle_sa_L0+0, 1
	MOVF       SSD1306_FillTriangle_dx12_L0+1, 0
	ADDWFC     SSD1306_FillTriangle_sa_L0+1, 1
	MOVLW      0
	BTFSC      SSD1306_FillTriangle_dx12_L0+1, 7
	MOVLW      255
	ADDWFC     SSD1306_FillTriangle_sa_L0+2, 1
	ADDWFC     SSD1306_FillTriangle_sa_L0+3, 1
;ssd1306oled.c,759 :: 		sb += dx02;
	MOVF       SSD1306_FillTriangle_dx02_L0+0, 0
	ADDWF      SSD1306_FillTriangle_sb_L0+0, 1
	MOVF       SSD1306_FillTriangle_dx02_L0+1, 0
	ADDWFC     SSD1306_FillTriangle_sb_L0+1, 1
	MOVLW      0
	BTFSC      SSD1306_FillTriangle_dx02_L0+1, 7
	MOVLW      255
	ADDWFC     SSD1306_FillTriangle_sb_L0+2, 1
	ADDWFC     SSD1306_FillTriangle_sb_L0+3, 1
;ssd1306oled.c,764 :: 		if(a > b) ssd1306_swap(a, b);
	MOVLW      128
	XORWF      R5, 0
	MOVWF      R0
	MOVLW      128
	XORWF      FLOC__SSD1306_FillTriangle+1, 0
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillTriangle233
	MOVF       FLOC__SSD1306_FillTriangle+0, 0
	SUBWF      R4, 0
L__SSD1306_FillTriangle233:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillTriangle69
	MOVF       SSD1306_FillTriangle_a_L0+0, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2_L2+0
	MOVF       SSD1306_FillTriangle_a_L0+1, 0
	MOVWF      SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2_L2+1
	MOVF       SSD1306_FillTriangle_b_L0+0, 0
	MOVWF      SSD1306_FillTriangle_a_L0+0
	MOVF       SSD1306_FillTriangle_b_L0+1, 0
	MOVWF      SSD1306_FillTriangle_a_L0+1
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2_L2+0, 0
	MOVWF      SSD1306_FillTriangle_b_L0+0
	MOVF       SSD1306_FillTriangle_t_L2_L2_L2_L2_L2_L2_L2_L2+1, 0
	MOVWF      SSD1306_FillTriangle_b_L0+1
L_SSD1306_FillTriangle69:
;ssd1306oled.c,765 :: 		SSD1306_DrawFastHLine(a, y, b - a + 1);
	MOVF       SSD1306_FillTriangle_a_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_x+0
	MOVF       SSD1306_FillTriangle_y_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_y+0
	MOVF       SSD1306_FillTriangle_a_L0+0, 0
	SUBWF      SSD1306_FillTriangle_b_L0+0, 0
	MOVWF      FARG_SSD1306_DrawFastHLine_w+0
	INCF       FARG_SSD1306_DrawFastHLine_w+0, 1
	CALL       _SSD1306_DrawFastHLine+0
;ssd1306oled.c,755 :: 		for(; y <= y2; y++) {
	INCF       SSD1306_FillTriangle_y_L0+0, 1
	BTFSC      STATUS+0, 2
	INCF       SSD1306_FillTriangle_y_L0+1, 1
;ssd1306oled.c,766 :: 		}
	GOTO       L_SSD1306_FillTriangle66
L_SSD1306_FillTriangle67:
;ssd1306oled.c,767 :: 		}
L_end_SSD1306_FillTriangle:
	RETURN
; end of _SSD1306_FillTriangle

_SSD1306_FillScreen:

;ssd1306oled.c,769 :: 		void SSD1306_FillScreen() {
;ssd1306oled.c,771 :: 		for (i = 0; i < (SSD1306_LCDWIDTH * SSD1306_LCDHEIGHT) / 8; i++)
	CLRF       R2+0
	CLRF       R2+1
L_SSD1306_FillScreen70:
	MOVLW      2
	SUBWF      R2+1, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_FillScreen235
	MOVLW      0
	SUBWF      R2+0, 0
L__SSD1306_FillScreen235:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_FillScreen71
;ssd1306oled.c,772 :: 		buffer[i] = 0xFF;
	MOVLW      si5351SDR_firmware_buffer+0
	MOVWF      R0
	MOVLW      hi_addr(si5351SDR_firmware_buffer+0)
	MOVWF      R1
	MOVF       R2+0, 0
	ADDWF      R0, 0
	MOVWF      FSR1L
	MOVF       R2+1, 0
	ADDWFC     R1, 0
	MOVWF      FSR1H
	MOVLW      255
	MOVWF      INDF1+0
;ssd1306oled.c,771 :: 		for (i = 0; i < (SSD1306_LCDWIDTH * SSD1306_LCDHEIGHT) / 8; i++)
	INCF       R2+0, 1
	BTFSC      STATUS+0, 2
	INCF       R2+1, 1
;ssd1306oled.c,772 :: 		buffer[i] = 0xFF;
	GOTO       L_SSD1306_FillScreen70
L_SSD1306_FillScreen71:
;ssd1306oled.c,773 :: 		}
L_end_SSD1306_FillScreen:
	RETURN
; end of _SSD1306_FillScreen

_SSD1306_SetTextWrap:

;ssd1306oled.c,775 :: 		void SSD1306_SetTextWrap(bool w) {
;ssd1306oled.c,776 :: 		wrap = w;
	MOVF       FARG_SSD1306_SetTextWrap_w+0, 0
	MOVWF      _wrap+0
;ssd1306oled.c,777 :: 		}
L_end_SSD1306_SetTextWrap:
	RETURN
; end of _SSD1306_SetTextWrap

_SSD1306_InvertDisplay:

;ssd1306oled.c,780 :: 		void SSD1306_InvertDisplay(bool i) {
;ssd1306oled.c,781 :: 		if (i)
	MOVF       FARG_SSD1306_InvertDisplay_i+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_InvertDisplay73
;ssd1306oled.c,782 :: 		ssd1306_command(SSD1306_INVERTDISPLAY_);
	MOVLW      167
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
	GOTO       L_SSD1306_InvertDisplay74
L_SSD1306_InvertDisplay73:
;ssd1306oled.c,784 :: 		ssd1306_command(SSD1306_NORMALDISPLAY);
	MOVLW      166
	MOVWF      FARG_ssd1306_command_c+0
	CALL       _ssd1306_command+0
L_SSD1306_InvertDisplay74:
;ssd1306oled.c,785 :: 		}
L_end_SSD1306_InvertDisplay:
	RETURN
; end of _SSD1306_InvertDisplay

_SSD1306_TextSize:

;ssd1306oled.c,788 :: 		void SSD1306_TextSize(uint8_t t_size)
;ssd1306oled.c,790 :: 		if(t_size < 1)
	MOVLW      1
	SUBWF      FARG_SSD1306_TextSize_t_size+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_TextSize75
;ssd1306oled.c,791 :: 		t_size = 1;
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
L_SSD1306_TextSize75:
;ssd1306oled.c,792 :: 		text_size = t_size;
	MOVF       FARG_SSD1306_TextSize_t_size+0, 0
	MOVWF      _text_size+0
;ssd1306oled.c,793 :: 		}
L_end_SSD1306_TextSize:
	RETURN
; end of _SSD1306_TextSize

_SSD1306_GotoXY:

;ssd1306oled.c,796 :: 		void SSD1306_GotoXY(uint8_t x, uint8_t y)
;ssd1306oled.c,798 :: 		if((x >= SSD1306_LCDWIDTH) || (y >= SSD1306_LCDHEIGHT))
	MOVLW      128
	SUBWF      FARG_SSD1306_GotoXY_x+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L__SSD1306_GotoXY169
	MOVLW      32
	SUBWF      FARG_SSD1306_GotoXY_y+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L__SSD1306_GotoXY169
	GOTO       L_SSD1306_GotoXY78
L__SSD1306_GotoXY169:
;ssd1306oled.c,799 :: 		return;
	GOTO       L_end_SSD1306_GotoXY
L_SSD1306_GotoXY78:
;ssd1306oled.c,800 :: 		x_pos = x;
	MOVF       FARG_SSD1306_GotoXY_x+0, 0
	MOVWF      _x_pos+0
;ssd1306oled.c,801 :: 		y_pos = y;
	MOVF       FARG_SSD1306_GotoXY_y+0, 0
	MOVWF      _y_pos+0
;ssd1306oled.c,802 :: 		}
L_end_SSD1306_GotoXY:
	RETURN
; end of _SSD1306_GotoXY

_SSD1306_PutC:

;ssd1306oled.c,810 :: 		void SSD1306_PutC(uint8_t c) {
;ssd1306oled.c,813 :: 		if(c == '\a') {
	MOVF       FARG_SSD1306_PutC_c+0, 0
	XORLW      7
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_PutC79
;ssd1306oled.c,814 :: 		x_pos = y_pos = 0;
	CLRF       _y_pos+0
	CLRF       _x_pos+0
;ssd1306oled.c,815 :: 		return;
	GOTO       L_end_SSD1306_PutC
;ssd1306oled.c,816 :: 		}
L_SSD1306_PutC79:
;ssd1306oled.c,817 :: 		if( (c == '\b') && (x_pos >= text_size * 6) ) {
	MOVF       FARG_SSD1306_PutC_c+0, 0
	XORLW      8
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_PutC82
	MOVF       _text_size+0, 0
	MOVWF      R0
	MOVLW      6
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVLW      128
	MOVWF      R2
	MOVLW      128
	XORWF      R1, 0
	SUBWF      R2, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_PutC241
	MOVF       R0, 0
	SUBWF      _x_pos+0, 0
L__SSD1306_PutC241:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_PutC82
L__SSD1306_PutC172:
;ssd1306oled.c,818 :: 		x_pos -= text_size * 6;
	MOVF       _text_size+0, 0
	MOVWF      R0
	MOVLW      6
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       R0, 0
	SUBWF      _x_pos+0, 1
;ssd1306oled.c,819 :: 		return;
	GOTO       L_end_SSD1306_PutC
;ssd1306oled.c,820 :: 		}
L_SSD1306_PutC82:
;ssd1306oled.c,821 :: 		if(c == '\r') {
	MOVF       FARG_SSD1306_PutC_c+0, 0
	XORLW      13
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_PutC83
;ssd1306oled.c,822 :: 		x_pos = 0;
	CLRF       _x_pos+0
;ssd1306oled.c,823 :: 		return;
	GOTO       L_end_SSD1306_PutC
;ssd1306oled.c,824 :: 		}
L_SSD1306_PutC83:
;ssd1306oled.c,825 :: 		if(c == '\n') {
	MOVF       FARG_SSD1306_PutC_c+0, 0
	XORLW      10
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_PutC84
;ssd1306oled.c,826 :: 		y_pos += text_size * 8;
	MOVF       _text_size+0, 0
	MOVWF      R0
	LSLF       R0, 1
	LSLF       R0, 1
	LSLF       R0, 1
	MOVF       R0, 0
	ADDWF      _y_pos+0, 0
	MOVWF      FLOC__SSD1306_PutC+0
	MOVF       FLOC__SSD1306_PutC+0, 0
	MOVWF      _y_pos+0
;ssd1306oled.c,827 :: 		if((y_pos + text_size * 7) >= SSD1306_LCDHEIGHT)
	MOVF       _text_size+0, 0
	MOVWF      R0
	MOVLW      7
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       FLOC__SSD1306_PutC+0, 0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      128
	XORWF      R3, 0
	MOVWF      R0
	MOVLW      128
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_PutC242
	MOVLW      32
	SUBWF      R2, 0
L__SSD1306_PutC242:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_PutC85
;ssd1306oled.c,828 :: 		y_pos = 0;
	CLRF       _y_pos+0
L_SSD1306_PutC85:
;ssd1306oled.c,829 :: 		return;
	GOTO       L_end_SSD1306_PutC
;ssd1306oled.c,830 :: 		}
L_SSD1306_PutC84:
;ssd1306oled.c,832 :: 		if((c < ' ') || (c > '~'))
	MOVLW      32
	SUBWF      FARG_SSD1306_PutC_c+0, 0
	BTFSS      STATUS+0, 0
	GOTO       L__SSD1306_PutC171
	MOVF       FARG_SSD1306_PutC_c+0, 0
	SUBLW      126
	BTFSS      STATUS+0, 0
	GOTO       L__SSD1306_PutC171
	GOTO       L_SSD1306_PutC88
L__SSD1306_PutC171:
;ssd1306oled.c,833 :: 		c = '?';
	MOVLW      63
	MOVWF      FARG_SSD1306_PutC_c+0
L_SSD1306_PutC88:
;ssd1306oled.c,834 :: 		for(i = 0; i < 5; i++ ) {
	CLRF       SSD1306_PutC_i_L0+0
L_SSD1306_PutC89:
	MOVLW      5
	SUBWF      SSD1306_PutC_i_L0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_PutC90
;ssd1306oled.c,835 :: 		line = font[(c - 32) * 5 + i];
	MOVLW      32
	SUBWF      FARG_SSD1306_PutC_c+0, 0
	MOVWF      R0
	CLRF       R1
	MOVLW      0
	SUBWFB     R1, 1
	MOVLW      5
	MOVWF      R4
	MOVLW      0
	MOVWF      R5
	CALL       _Mul_16X16_U+0
	MOVF       SSD1306_PutC_i_L0+0, 0
	ADDWF      R0, 1
	MOVLW      0
	ADDWFC     R1, 1
	MOVLW      _Font+0
	ADDWF      R0, 0
	MOVWF      FSR0L
	MOVLW      hi_addr(_Font+0)
	ADDWFC     R1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      SSD1306_PutC_line_L0+0
;ssd1306oled.c,837 :: 		for(j = 0; j < 7; j++, line >>= 1) {
	CLRF       SSD1306_PutC_j_L0+0
L_SSD1306_PutC92:
	MOVLW      7
	SUBWF      SSD1306_PutC_j_L0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_PutC93
;ssd1306oled.c,838 :: 		if(line & 0x01)
	BTFSS      SSD1306_PutC_line_L0+0, 0
	GOTO       L_SSD1306_PutC95
;ssd1306oled.c,839 :: 		SSD1306_Color = true;
	MOVLW      1
	MOVWF      _SSD1306_Color+0
	GOTO       L_SSD1306_PutC96
L_SSD1306_PutC95:
;ssd1306oled.c,841 :: 		SSD1306_Color = false;
	CLRF       _SSD1306_Color+0
L_SSD1306_PutC96:
;ssd1306oled.c,842 :: 		if(text_size == 1) SSD1306_DrawPixel(x_pos + i, y_pos + j);
	MOVF       _text_size+0, 0
	XORLW      1
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_PutC97
	MOVF       SSD1306_PutC_i_L0+0, 0
	ADDWF      _x_pos+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_PutC_j_L0+0, 0
	ADDWF      _y_pos+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
	GOTO       L_SSD1306_PutC98
L_SSD1306_PutC97:
;ssd1306oled.c,843 :: 		else               SSD1306_FillRect(x_pos + (i * text_size), y_pos + (j * text_size), text_size, text_size);
	MOVF       SSD1306_PutC_i_L0+0, 0
	MOVWF      R0
	MOVF       _text_size+0, 0
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       R0, 0
	ADDWF      _x_pos+0, 0
	MOVWF      FARG_SSD1306_FillRect_x+0
	MOVF       SSD1306_PutC_j_L0+0, 0
	MOVWF      R0
	MOVF       _text_size+0, 0
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       R0, 0
	ADDWF      _y_pos+0, 0
	MOVWF      FARG_SSD1306_FillRect_y+0
	MOVF       _text_size+0, 0
	MOVWF      FARG_SSD1306_FillRect_w+0
	MOVF       _text_size+0, 0
	MOVWF      FARG_SSD1306_FillRect_h+0
	CALL       _SSD1306_FillRect+0
L_SSD1306_PutC98:
;ssd1306oled.c,837 :: 		for(j = 0; j < 7; j++, line >>= 1) {
	INCF       SSD1306_PutC_j_L0+0, 1
	LSRF       SSD1306_PutC_line_L0+0, 1
;ssd1306oled.c,844 :: 		}
	GOTO       L_SSD1306_PutC92
L_SSD1306_PutC93:
;ssd1306oled.c,834 :: 		for(i = 0; i < 5; i++ ) {
	INCF       SSD1306_PutC_i_L0+0, 1
;ssd1306oled.c,845 :: 		}
	GOTO       L_SSD1306_PutC89
L_SSD1306_PutC90:
;ssd1306oled.c,847 :: 		SSD1306_Color = false;
	CLRF       _SSD1306_Color+0
;ssd1306oled.c,848 :: 		SSD1306_FillRect(x_pos + (5 * text_size), y_pos, text_size, 7 * text_size);
	MOVLW      5
	MOVWF      R0
	MOVF       _text_size+0, 0
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       R0, 0
	ADDWF      _x_pos+0, 0
	MOVWF      FARG_SSD1306_FillRect_x+0
	MOVF       _y_pos+0, 0
	MOVWF      FARG_SSD1306_FillRect_y+0
	MOVF       _text_size+0, 0
	MOVWF      FARG_SSD1306_FillRect_w+0
	MOVLW      7
	MOVWF      R0
	MOVF       _text_size+0, 0
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       R0, 0
	MOVWF      FARG_SSD1306_FillRect_h+0
	CALL       _SSD1306_FillRect+0
;ssd1306oled.c,850 :: 		x_pos += text_size * 6;
	MOVF       _text_size+0, 0
	MOVWF      R0
	MOVLW      6
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       R0, 0
	ADDWF      _x_pos+0, 1
;ssd1306oled.c,851 :: 		if (wrap && (x_pos + (text_size * 5)) >= SSD1306_LCDWIDTH)
	MOVF       _wrap+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_PutC101
	MOVF       _text_size+0, 0
	MOVWF      R0
	MOVLW      5
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       _x_pos+0, 0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      128
	XORWF      R3, 0
	MOVWF      R0
	MOVLW      128
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_PutC243
	MOVLW      128
	SUBWF      R2, 0
L__SSD1306_PutC243:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_PutC101
L__SSD1306_PutC170:
;ssd1306oled.c,853 :: 		x_pos = 0;
	CLRF       _x_pos+0
;ssd1306oled.c,854 :: 		y_pos += text_size * 8;
	MOVF       _text_size+0, 0
	MOVWF      R0
	LSLF       R0, 1
	LSLF       R0, 1
	LSLF       R0, 1
	MOVF       R0, 0
	ADDWF      _y_pos+0, 0
	MOVWF      FLOC__SSD1306_PutC+0
	MOVF       FLOC__SSD1306_PutC+0, 0
	MOVWF      _y_pos+0
;ssd1306oled.c,855 :: 		if((y_pos + text_size * 7) >= SSD1306_LCDHEIGHT)
	MOVF       _text_size+0, 0
	MOVWF      R0
	MOVLW      7
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       FLOC__SSD1306_PutC+0, 0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      128
	XORWF      R3, 0
	MOVWF      R0
	MOVLW      128
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_PutC244
	MOVLW      32
	SUBWF      R2, 0
L__SSD1306_PutC244:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_PutC102
;ssd1306oled.c,856 :: 		y_pos = 0;
	CLRF       _y_pos+0
L_SSD1306_PutC102:
;ssd1306oled.c,857 :: 		}
L_SSD1306_PutC101:
;ssd1306oled.c,858 :: 		}
L_end_SSD1306_PutC:
	RETURN
; end of _SSD1306_PutC

_SSD1306_Print:

;ssd1306oled.c,861 :: 		void SSD1306_Print(char *s) {
;ssd1306oled.c,862 :: 		uint8_t i = 0;
	CLRF       SSD1306_Print_i_L0+0
;ssd1306oled.c,863 :: 		while (s[i] != '\0'){
L_SSD1306_Print103:
	MOVF       SSD1306_Print_i_L0+0, 0
	ADDWF      FARG_SSD1306_Print_s+0, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     FARG_SSD1306_Print_s+1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	XORLW      0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_Print104
;ssd1306oled.c,864 :: 		if (s[i] == ' ' && x_pos == 0 && wrap)
	MOVF       SSD1306_Print_i_L0+0, 0
	ADDWF      FARG_SSD1306_Print_s+0, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     FARG_SSD1306_Print_s+1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	XORLW      32
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_Print107
	MOVF       _x_pos+0, 0
	XORLW      0
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_Print107
	MOVF       _wrap+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_Print107
L__SSD1306_Print173:
;ssd1306oled.c,865 :: 		i++;
	INCF       SSD1306_Print_i_L0+0, 1
	GOTO       L_SSD1306_Print108
L_SSD1306_Print107:
;ssd1306oled.c,867 :: 		SSD1306_PutC(s[i++]);
	MOVF       SSD1306_Print_i_L0+0, 0
	ADDWF      FARG_SSD1306_Print_s+0, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     FARG_SSD1306_Print_s+1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      FARG_SSD1306_PutC_c+0
	CALL       _SSD1306_PutC+0
	INCF       SSD1306_Print_i_L0+0, 1
L_SSD1306_Print108:
;ssd1306oled.c,868 :: 		}
	GOTO       L_SSD1306_Print103
L_SSD1306_Print104:
;ssd1306oled.c,869 :: 		}
L_end_SSD1306_Print:
	RETURN
; end of _SSD1306_Print

_SSD1306_PutCustomC:

;ssd1306oled.c,872 :: 		void SSD1306_PutCustomC(const uint8_t *c) {
;ssd1306oled.c,875 :: 		for(i = 0; i < 5; i++ ) {
	CLRF       SSD1306_PutCustomC_i_L0+0
L_SSD1306_PutCustomC109:
	MOVLW      5
	SUBWF      SSD1306_PutCustomC_i_L0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_PutCustomC110
;ssd1306oled.c,876 :: 		line = c[i];
	MOVF       SSD1306_PutCustomC_i_L0+0, 0
	ADDWF      FARG_SSD1306_PutCustomC_c+0, 0
	MOVWF      FSR0L
	MOVLW      0
	ADDWFC     FARG_SSD1306_PutCustomC_c+1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      SSD1306_PutCustomC_line_L0+0
;ssd1306oled.c,878 :: 		for(j = 0; j < 7; j++, line >>= 1) {
	CLRF       SSD1306_PutCustomC_j_L0+0
L_SSD1306_PutCustomC112:
	MOVLW      7
	SUBWF      SSD1306_PutCustomC_j_L0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_PutCustomC113
;ssd1306oled.c,879 :: 		if(line & 0x01)
	BTFSS      SSD1306_PutCustomC_line_L0+0, 0
	GOTO       L_SSD1306_PutCustomC115
;ssd1306oled.c,880 :: 		SSD1306_Color = 1;
	MOVLW      1
	MOVWF      _SSD1306_Color+0
	GOTO       L_SSD1306_PutCustomC116
L_SSD1306_PutCustomC115:
;ssd1306oled.c,882 :: 		SSD1306_Color = 0;
	CLRF       _SSD1306_Color+0
L_SSD1306_PutCustomC116:
;ssd1306oled.c,883 :: 		if(text_size == 1) SSD1306_DrawPixel(x_pos + i, y_pos + j);
	MOVF       _text_size+0, 0
	XORLW      1
	BTFSS      STATUS+0, 2
	GOTO       L_SSD1306_PutCustomC117
	MOVF       SSD1306_PutCustomC_i_L0+0, 0
	ADDWF      _x_pos+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVF       SSD1306_PutCustomC_j_L0+0, 0
	ADDWF      _y_pos+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	CALL       _SSD1306_DrawPixel+0
	GOTO       L_SSD1306_PutCustomC118
L_SSD1306_PutCustomC117:
;ssd1306oled.c,884 :: 		else               SSD1306_FillRect(x_pos + (i * text_size), y_pos + (j * text_size), text_size, text_size);
	MOVF       SSD1306_PutCustomC_i_L0+0, 0
	MOVWF      R0
	MOVF       _text_size+0, 0
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       R0, 0
	ADDWF      _x_pos+0, 0
	MOVWF      FARG_SSD1306_FillRect_x+0
	MOVF       SSD1306_PutCustomC_j_L0+0, 0
	MOVWF      R0
	MOVF       _text_size+0, 0
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       R0, 0
	ADDWF      _y_pos+0, 0
	MOVWF      FARG_SSD1306_FillRect_y+0
	MOVF       _text_size+0, 0
	MOVWF      FARG_SSD1306_FillRect_w+0
	MOVF       _text_size+0, 0
	MOVWF      FARG_SSD1306_FillRect_h+0
	CALL       _SSD1306_FillRect+0
L_SSD1306_PutCustomC118:
;ssd1306oled.c,878 :: 		for(j = 0; j < 7; j++, line >>= 1) {
	INCF       SSD1306_PutCustomC_j_L0+0, 1
	LSRF       SSD1306_PutCustomC_line_L0+0, 1
;ssd1306oled.c,885 :: 		}
	GOTO       L_SSD1306_PutCustomC112
L_SSD1306_PutCustomC113:
;ssd1306oled.c,875 :: 		for(i = 0; i < 5; i++ ) {
	INCF       SSD1306_PutCustomC_i_L0+0, 1
;ssd1306oled.c,886 :: 		}
	GOTO       L_SSD1306_PutCustomC109
L_SSD1306_PutCustomC110:
;ssd1306oled.c,888 :: 		x_pos += (text_size * 6);
	MOVF       _text_size+0, 0
	MOVWF      R0
	MOVLW      6
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       R0, 0
	ADDWF      _x_pos+0, 1
;ssd1306oled.c,889 :: 		if (wrap && (x_pos + (text_size * 5)) >= SSD1306_LCDWIDTH)
	MOVF       _wrap+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_PutCustomC121
	MOVF       _text_size+0, 0
	MOVWF      R0
	MOVLW      5
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       _x_pos+0, 0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      128
	XORWF      R3, 0
	MOVWF      R0
	MOVLW      128
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_PutCustomC247
	MOVLW      128
	SUBWF      R2, 0
L__SSD1306_PutCustomC247:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_PutCustomC121
L__SSD1306_PutCustomC174:
;ssd1306oled.c,891 :: 		x_pos = 0;
	CLRF       _x_pos+0
;ssd1306oled.c,892 :: 		y_pos += text_size * 8;
	MOVF       _text_size+0, 0
	MOVWF      R0
	LSLF       R0, 1
	LSLF       R0, 1
	LSLF       R0, 1
	MOVF       R0, 0
	ADDWF      _y_pos+0, 0
	MOVWF      FLOC__SSD1306_PutCustomC+0
	MOVF       FLOC__SSD1306_PutCustomC+0, 0
	MOVWF      _y_pos+0
;ssd1306oled.c,893 :: 		if((y_pos + text_size * 7) >= SSD1306_LCDHEIGHT)
	MOVF       _text_size+0, 0
	MOVWF      R0
	MOVLW      7
	MOVWF      R4
	CALL       _Mul_8X8_U+0
	MOVF       FLOC__SSD1306_PutCustomC+0, 0
	ADDWF      R0, 0
	MOVWF      R2
	MOVLW      0
	ADDWFC     R1, 0
	MOVWF      R3
	MOVLW      128
	XORWF      R3, 0
	MOVWF      R0
	MOVLW      128
	SUBWF      R0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_PutCustomC248
	MOVLW      32
	SUBWF      R2, 0
L__SSD1306_PutCustomC248:
	BTFSS      STATUS+0, 0
	GOTO       L_SSD1306_PutCustomC122
;ssd1306oled.c,894 :: 		y_pos = 0;
	CLRF       _y_pos+0
L_SSD1306_PutCustomC122:
;ssd1306oled.c,895 :: 		}
L_SSD1306_PutCustomC121:
;ssd1306oled.c,896 :: 		}
L_end_SSD1306_PutCustomC:
	RETURN
; end of _SSD1306_PutCustomC

_SSD1306_DrawBMP:

;ssd1306oled.c,899 :: 		void SSD1306_DrawBMP(uint8_t x, uint8_t y, const uint8_t *bitmap, uint8_t w, uint8_t h)
;ssd1306oled.c,903 :: 		for (j = 0; j < h/8; j++) {
	CLRF       SSD1306_DrawBMP_j_L0+0
	CLRF       SSD1306_DrawBMP_j_L0+1
L_SSD1306_DrawBMP123:
	MOVF       FARG_SSD1306_DrawBMP_h+0, 0
	MOVWF      R1
	LSRF       R1, 1
	LSRF       R1, 1
	LSRF       R1, 1
	MOVLW      0
	SUBWF      SSD1306_DrawBMP_j_L0+1, 0
	BTFSS      STATUS+0, 2
	GOTO       L__SSD1306_DrawBMP250
	MOVF       R1, 0
	SUBWF      SSD1306_DrawBMP_j_L0+0, 0
L__SSD1306_DrawBMP250:
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_DrawBMP124
;ssd1306oled.c,904 :: 		for(i = 0; i < w; i++)   {
	CLRF       SSD1306_DrawBMP_i_L0+0
L_SSD1306_DrawBMP126:
	MOVF       FARG_SSD1306_DrawBMP_w+0, 0
	SUBWF      SSD1306_DrawBMP_i_L0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_DrawBMP127
;ssd1306oled.c,905 :: 		for(k = 0; k < 8; k++)  {
	CLRF       SSD1306_DrawBMP_k_L0+0
L_SSD1306_DrawBMP129:
	MOVLW      8
	SUBWF      SSD1306_DrawBMP_k_L0+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L_SSD1306_DrawBMP130
;ssd1306oled.c,906 :: 		if( bitmap[i + j*w] & 1 << k)
	MOVF       SSD1306_DrawBMP_j_L0+0, 0
	MOVWF      R0
	MOVF       SSD1306_DrawBMP_j_L0+1, 0
	MOVWF      R1
	MOVF       FARG_SSD1306_DrawBMP_w+0, 0
	MOVWF      R4
	CLRF       R5
	CALL       _Mul_16X16_U+0
	MOVF       SSD1306_DrawBMP_i_L0+0, 0
	ADDWF      R0, 1
	MOVLW      0
	ADDWFC     R1, 1
	MOVF       R0, 0
	ADDWF      FARG_SSD1306_DrawBMP_bitmap+0, 0
	MOVWF      FSR0L
	MOVF       R1, 0
	ADDWFC     FARG_SSD1306_DrawBMP_bitmap+1, 0
	MOVWF      FSR0H
	MOVF       INDF0+0, 0
	MOVWF      R3
	MOVF       SSD1306_DrawBMP_k_L0+0, 0
	MOVWF      R2
	MOVLW      1
	MOVWF      R0
	MOVLW      0
	MOVWF      R1
	MOVF       R2, 0
L__SSD1306_DrawBMP251:
	BTFSC      STATUS+0, 2
	GOTO       L__SSD1306_DrawBMP252
	LSLF       R0, 1
	RLF        R1, 1
	ADDLW      255
	GOTO       L__SSD1306_DrawBMP251
L__SSD1306_DrawBMP252:
	MOVF       R3, 0
	ANDWF      R0, 1
	MOVLW      0
	ANDWF      R1, 1
	MOVF       R0, 0
	IORWF       R1, 0
	BTFSC      STATUS+0, 2
	GOTO       L_SSD1306_DrawBMP132
;ssd1306oled.c,907 :: 		SSD1306_Color = true;
	MOVLW      1
	MOVWF      _SSD1306_Color+0
	GOTO       L_SSD1306_DrawBMP133
L_SSD1306_DrawBMP132:
;ssd1306oled.c,909 :: 		SSD1306_Color = false;
	CLRF       _SSD1306_Color+0
L_SSD1306_DrawBMP133:
;ssd1306oled.c,910 :: 		SSD1306_DrawPixel(x + i, y + j*8 + k);
	MOVF       SSD1306_DrawBMP_i_L0+0, 0
	ADDWF      FARG_SSD1306_DrawBMP_x+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_x+0
	MOVLW      3
	MOVWF      R1
	MOVF       SSD1306_DrawBMP_j_L0+0, 0
	MOVWF      R0
	MOVF       R1, 0
L__SSD1306_DrawBMP253:
	BTFSC      STATUS+0, 2
	GOTO       L__SSD1306_DrawBMP254
	LSLF       R0, 1
	ADDLW      255
	GOTO       L__SSD1306_DrawBMP253
L__SSD1306_DrawBMP254:
	MOVF       R0, 0
	ADDWF      FARG_SSD1306_DrawBMP_y+0, 0
	MOVWF      FARG_SSD1306_DrawPixel_y+0
	MOVF       SSD1306_DrawBMP_k_L0+0, 0
	ADDWF      FARG_SSD1306_DrawPixel_y+0, 1
	CALL       _SSD1306_DrawPixel+0
;ssd1306oled.c,905 :: 		for(k = 0; k < 8; k++)  {
	INCF       SSD1306_DrawBMP_k_L0+0, 1
;ssd1306oled.c,911 :: 		}
	GOTO       L_SSD1306_DrawBMP129
L_SSD1306_DrawBMP130:
;ssd1306oled.c,904 :: 		for(i = 0; i < w; i++)   {
	INCF       SSD1306_DrawBMP_i_L0+0, 1
;ssd1306oled.c,912 :: 		}
	GOTO       L_SSD1306_DrawBMP126
L_SSD1306_DrawBMP127:
;ssd1306oled.c,903 :: 		for (j = 0; j < h/8; j++) {
	INCF       SSD1306_DrawBMP_j_L0+0, 1
	BTFSC      STATUS+0, 2
	INCF       SSD1306_DrawBMP_j_L0+1, 1
;ssd1306oled.c,913 :: 		}
	GOTO       L_SSD1306_DrawBMP123
L_SSD1306_DrawBMP124:
;ssd1306oled.c,914 :: 		}
L_end_SSD1306_DrawBMP:
	RETURN
; end of _SSD1306_DrawBMP

_Controls:

;si5351SDR_firmware.c,11 :: 		char Controls(){
;si5351SDR_firmware.c,13 :: 		while(EncodIn){
L_Controls134:
	MOVLW      3
	ANDWF      PORTA+0, 0
	MOVWF      R0
	BTFSC      STATUS+0, 2
	GOTO       L_Controls135
;si5351SDR_firmware.c,14 :: 		SelectMode();
	CALL       _SelectMode+0
;si5351SDR_firmware.c,15 :: 		SelectStep();
	CALL       _SelectStep+0
;si5351SDR_firmware.c,16 :: 		}
	GOTO       L_Controls134
L_Controls135:
;si5351SDR_firmware.c,17 :: 		while((EncodIn)== 0x00){
L_Controls136:
	MOVLW      3
	ANDWF      PORTA+0, 0
	MOVWF      R1
	MOVF       R1, 0
	XORLW      0
	BTFSS      STATUS+0, 2
	GOTO       L_Controls137
;si5351SDR_firmware.c,18 :: 		SelectMode();
	CALL       _SelectMode+0
;si5351SDR_firmware.c,19 :: 		SelectStep();
	CALL       _SelectStep+0
;si5351SDR_firmware.c,20 :: 		}
	GOTO       L_Controls136
L_Controls137:
;si5351SDR_firmware.c,21 :: 		delay_ms(1);
	MOVLW      6
	MOVWF      R12
	MOVLW      48
	MOVWF      R13
L_Controls138:
	DECFSZ     R13, 1
	GOTO       L_Controls138
	DECFSZ     R12, 1
	GOTO       L_Controls138
	NOP
;si5351SDR_firmware.c,22 :: 		Freq+=(EncodeVals[EncodIn]*StepVal);
	MOVLW      3
	ANDWF      PORTA+0, 0
	MOVWF      R0
	MOVLW      Controls_EncodeVals_L0+0
	MOVWF      FSR0L
	MOVLW      hi_addr(Controls_EncodeVals_L0+0)
	MOVWF      FSR0H
	MOVF       R0, 0
	ADDWF      FSR0L, 1
	BTFSC      STATUS+0, 0
	INCF       FSR0H, 1
	MOVF       INDF0+0, 0
	MOVWF      R0
	MOVLW      0
	BTFSC      R0, 7
	MOVLW      255
	MOVWF      R1
	MOVWF      R2
	MOVWF      R3
	MOVF       _StepVal+0, 0
	MOVWF      R4
	MOVF       _StepVal+1, 0
	MOVWF      R5
	MOVF       _StepVal+2, 0
	MOVWF      R6
	MOVF       _StepVal+3, 0
	MOVWF      R7
	CALL       _Mul_32x32_U+0
	MOVF       R0, 0
	ADDWF      _Freq+0, 0
	MOVWF      R4
	MOVF       R1, 0
	ADDWFC     _Freq+1, 0
	MOVWF      R5
	MOVF       R2, 0
	ADDWFC     _Freq+2, 0
	MOVWF      R6
	MOVF       R3, 0
	ADDWFC     _Freq+3, 0
	MOVWF      R7
	MOVF       R4, 0
	MOVWF      _Freq+0
	MOVF       R5, 0
	MOVWF      _Freq+1
	MOVF       R6, 0
	MOVWF      _Freq+2
	MOVF       R7, 0
	MOVWF      _Freq+3
;si5351SDR_firmware.c,23 :: 		if(freq > 16000000)freq = 16000000;
	MOVF       R7, 0
	SUBLW      0
	BTFSS      STATUS+0, 2
	GOTO       L__Controls256
	MOVF       R6, 0
	SUBLW      244
	BTFSS      STATUS+0, 2
	GOTO       L__Controls256
	MOVF       R5, 0
	SUBLW      36
	BTFSS      STATUS+0, 2
	GOTO       L__Controls256
	MOVF       R4, 0
	SUBLW      0
L__Controls256:
	BTFSC      STATUS+0, 0
	GOTO       L_Controls139
	MOVLW      0
	MOVWF      _Freq+0
	MOVLW      36
	MOVWF      _Freq+1
	MOVLW      244
	MOVWF      _Freq+2
	MOVLW      0
	MOVWF      _Freq+3
L_Controls139:
;si5351SDR_firmware.c,24 :: 		if(freq < 201000) freq = 201000;
	MOVLW      0
	SUBWF      _Freq+3, 0
	BTFSS      STATUS+0, 2
	GOTO       L__Controls257
	MOVLW      3
	SUBWF      _Freq+2, 0
	BTFSS      STATUS+0, 2
	GOTO       L__Controls257
	MOVLW      17
	SUBWF      _Freq+1, 0
	BTFSS      STATUS+0, 2
	GOTO       L__Controls257
	MOVLW      40
	SUBWF      _Freq+0, 0
L__Controls257:
	BTFSC      STATUS+0, 0
	GOTO       L_Controls140
	MOVLW      40
	MOVWF      _Freq+0
	MOVLW      17
	MOVWF      _Freq+1
	MOVLW      3
	MOVWF      _Freq+2
	MOVLW      0
	MOVWF      _Freq+3
L_Controls140:
;si5351SDR_firmware.c,25 :: 		return (EncodIn);
	MOVLW      3
	ANDWF      PORTA+0, 0
	MOVWF      R0
;si5351SDR_firmware.c,26 :: 		}
L_end_Controls:
	RETURN
; end of _Controls

_SelectStep:

;si5351SDR_firmware.c,28 :: 		unsigned long SelectStep(){
;si5351SDR_firmware.c,29 :: 		if(StepSW == 1){
	BTFSS      PORTA+0, 3
	GOTO       L_SelectStep141
;si5351SDR_firmware.c,30 :: 		StepCnt++;
	INCF       _StepCnt+0, 1
;si5351SDR_firmware.c,31 :: 		while(StepSW == 1);
L_SelectStep142:
	BTFSS      PORTA+0, 3
	GOTO       L_SelectStep143
	GOTO       L_SelectStep142
L_SelectStep143:
;si5351SDR_firmware.c,32 :: 		delay_ms(20);
	MOVLW      104
	MOVWF      R12
	MOVLW      228
	MOVWF      R13
L_SelectStep144:
	DECFSZ     R13, 1
	GOTO       L_SelectStep144
	DECFSZ     R12, 1
	GOTO       L_SelectStep144
	NOP
;si5351SDR_firmware.c,33 :: 		if(StepCnt > 6)StepCnt = 1;
	MOVF       _StepCnt+0, 0
	SUBLW      6
	BTFSC      STATUS+0, 0
	GOTO       L_SelectStep145
	MOVLW      1
	MOVWF      _StepCnt+0
L_SelectStep145:
;si5351SDR_firmware.c,34 :: 		switch(StepCnt){
	GOTO       L_SelectStep146
;si5351SDR_firmware.c,35 :: 		case 1: StepVal = 10; print_10Hz; break;
L_SelectStep148:
	MOVLW      10
	MOVWF      _StepVal+0
	CLRF       _StepVal+1
	CLRF       _StepVal+2
	CLRF       _StepVal+3
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      91
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr1_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr1_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
	GOTO       L_SelectStep147
;si5351SDR_firmware.c,36 :: 		case 2: StepVal = 100; print_100Hz; break;
L_SelectStep149:
	MOVLW      100
	MOVWF      _StepVal+0
	CLRF       _StepVal+1
	CLRF       _StepVal+2
	CLRF       _StepVal+3
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      91
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr2_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr2_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
	GOTO       L_SelectStep147
;si5351SDR_firmware.c,37 :: 		case 3: StepVal = 1000; print_1KHz;  break;
L_SelectStep150:
	MOVLW      232
	MOVWF      _StepVal+0
	MOVLW      3
	MOVWF      _StepVal+1
	CLRF       _StepVal+2
	CLRF       _StepVal+3
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      91
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr3_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr3_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
	GOTO       L_SelectStep147
;si5351SDR_firmware.c,38 :: 		case 4: StepVal = 5000; print_5KHz;  break;
L_SelectStep151:
	MOVLW      136
	MOVWF      _StepVal+0
	MOVLW      19
	MOVWF      _StepVal+1
	CLRF       _StepVal+2
	CLRF       _StepVal+3
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      91
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr4_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr4_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
	GOTO       L_SelectStep147
;si5351SDR_firmware.c,39 :: 		case 5: StepVal = 100000; print_100KHz;  break;
L_SelectStep152:
	MOVLW      160
	MOVWF      _StepVal+0
	MOVLW      134
	MOVWF      _StepVal+1
	MOVLW      1
	MOVWF      _StepVal+2
	MOVLW      0
	MOVWF      _StepVal+3
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      91
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr5_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr5_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
	GOTO       L_SelectStep147
;si5351SDR_firmware.c,40 :: 		case 6: StepVal = 1; print_1Hz; break;
L_SelectStep153:
	MOVLW      1
	MOVWF      _StepVal+0
	CLRF       _StepVal+1
	CLRF       _StepVal+2
	CLRF       _StepVal+3
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      91
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr6_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr6_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
	GOTO       L_SelectStep147
;si5351SDR_firmware.c,41 :: 		}
L_SelectStep146:
	MOVF       _StepCnt+0, 0
	XORLW      1
	BTFSC      STATUS+0, 2
	GOTO       L_SelectStep148
	MOVF       _StepCnt+0, 0
	XORLW      2
	BTFSC      STATUS+0, 2
	GOTO       L_SelectStep149
	MOVF       _StepCnt+0, 0
	XORLW      3
	BTFSC      STATUS+0, 2
	GOTO       L_SelectStep150
	MOVF       _StepCnt+0, 0
	XORLW      4
	BTFSC      STATUS+0, 2
	GOTO       L_SelectStep151
	MOVF       _StepCnt+0, 0
	XORLW      5
	BTFSC      STATUS+0, 2
	GOTO       L_SelectStep152
	MOVF       _StepCnt+0, 0
	XORLW      6
	BTFSC      STATUS+0, 2
	GOTO       L_SelectStep153
L_SelectStep147:
;si5351SDR_firmware.c,42 :: 		}
L_SelectStep141:
;si5351SDR_firmware.c,43 :: 		return StepVal;
	MOVF       _StepVal+0, 0
	MOVWF      R0
	MOVF       _StepVal+1, 0
	MOVWF      R1
	MOVF       _StepVal+2, 0
	MOVWF      R2
	MOVF       _StepVal+3, 0
	MOVWF      R3
;si5351SDR_firmware.c,44 :: 		}
L_end_SelectStep:
	RETURN
; end of _SelectStep

_DisplayFreq:

;si5351SDR_firmware.c,46 :: 		void DisplayFreq(){
;si5351SDR_firmware.c,47 :: 		longtostr(Freq, LCDText);
	MOVF       _Freq+0, 0
	MOVWF      FARG_LongToStr_input+0
	MOVF       _Freq+1, 0
	MOVWF      FARG_LongToStr_input+1
	MOVF       _Freq+2, 0
	MOVWF      FARG_LongToStr_input+2
	MOVF       _Freq+3, 0
	MOVWF      FARG_LongToStr_input+3
	MOVLW      _LCDText+0
	MOVWF      FARG_LongToStr_output+0
	MOVLW      hi_addr(_LCDText+0)
	MOVWF      FARG_LongToStr_output+1
	CALL       _LongToStr+0
;si5351SDR_firmware.c,48 :: 		LCDText[0] =  LCDText[3];
	MOVF       _LCDText+3, 0
	MOVWF      _LCDText+0
;si5351SDR_firmware.c,49 :: 		LCDText[1] =  LCDText[4];
	MOVF       _LCDText+4, 0
	MOVWF      _LCDText+1
;si5351SDR_firmware.c,50 :: 		LCDText[2] = 0;
	CLRF       _LCDText+2
;si5351SDR_firmware.c,51 :: 		SSD1306_GotoXY(1,17);
	MOVLW      1
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      17
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
;si5351SDR_firmware.c,52 :: 		SSD1306_TextSize(2);
	MOVLW      2
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
;si5351SDR_firmware.c,53 :: 		SSD1306_Print(LCDText);
	MOVLW      _LCDText+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(_LCDText+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
;si5351SDR_firmware.c,54 :: 		SSD1306_Print(".");
	MOVLW      ?lstr7_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr7_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
;si5351SDR_firmware.c,55 :: 		LCDText[0] =  LCDText[5];
	MOVF       _LCDText+5, 0
	MOVWF      _LCDText+0
;si5351SDR_firmware.c,56 :: 		LCDText[1] =  LCDText[6];
	MOVF       _LCDText+6, 0
	MOVWF      _LCDText+1
;si5351SDR_firmware.c,57 :: 		LCDText[2] =  LCDText[7];
	MOVF       _LCDText+7, 0
	MOVWF      _LCDText+2
;si5351SDR_firmware.c,58 :: 		LCDText[3] =  LCDText[8];
	MOVF       _LCDText+8, 0
	MOVWF      _LCDText+3
;si5351SDR_firmware.c,59 :: 		LCDText[4] =  LCDText[9];
	MOVF       _LCDText+9, 0
	MOVWF      _LCDText+4
;si5351SDR_firmware.c,60 :: 		LCDText[5] =  LCDText[10];
	MOVF       _LCDText+10, 0
	MOVWF      _LCDText+5
;si5351SDR_firmware.c,61 :: 		LCDText[6] = 0;
	CLRF       _LCDText+6
;si5351SDR_firmware.c,62 :: 		SSD1306_Print(LCDText);
	MOVLW      _LCDText+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(_LCDText+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
;si5351SDR_firmware.c,63 :: 		SSD1306_Display();
	CALL       _SSD1306_Display+0
;si5351SDR_firmware.c,64 :: 		}
L_end_DisplayFreq:
	RETURN
; end of _DisplayFreq

_SelectMode:

;si5351SDR_firmware.c,66 :: 		void SelectMode(){
;si5351SDR_firmware.c,67 :: 		if(ModeSW == 1){
	BTFSS      PORTA+0, 4
	GOTO       L_SelectMode154
;si5351SDR_firmware.c,68 :: 		ModeCnt++;
	INCF       _ModeCnt+0, 1
;si5351SDR_firmware.c,69 :: 		while(ModeSW == 1);
L_SelectMode155:
	BTFSS      PORTA+0, 4
	GOTO       L_SelectMode156
	GOTO       L_SelectMode155
L_SelectMode156:
;si5351SDR_firmware.c,70 :: 		delay_ms(20);
	MOVLW      104
	MOVWF      R12
	MOVLW      228
	MOVWF      R13
L_SelectMode157:
	DECFSZ     R13, 1
	GOTO       L_SelectMode157
	DECFSZ     R12, 1
	GOTO       L_SelectMode157
	NOP
;si5351SDR_firmware.c,71 :: 		if(ModeCnt > 3)ModeCnt = 1;
	MOVF       _ModeCnt+0, 0
	SUBLW      3
	BTFSC      STATUS+0, 0
	GOTO       L_SelectMode158
	MOVLW      1
	MOVWF      _ModeCnt+0
L_SelectMode158:
;si5351SDR_firmware.c,72 :: 		switch(ModeCnt){
	GOTO       L_SelectMode159
;si5351SDR_firmware.c,73 :: 		case 1: AMSel; print_AM; break;
L_SelectMode161:
	CLRF       PORTC+0
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      1
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr8_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr8_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
	GOTO       L_SelectMode160
;si5351SDR_firmware.c,74 :: 		case 2: LSBSel; print_LSB; break;
L_SelectMode162:
	MOVLW      32
	MOVWF      PORTC+0
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      1
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr9_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr9_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
	GOTO       L_SelectMode160
;si5351SDR_firmware.c,75 :: 		case 3: USBSel; print_USB; break;
L_SelectMode163:
	MOVLW      16
	MOVWF      PORTC+0
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      1
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr10_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr10_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
	GOTO       L_SelectMode160
;si5351SDR_firmware.c,76 :: 		}
L_SelectMode159:
	MOVF       _ModeCnt+0, 0
	XORLW      1
	BTFSC      STATUS+0, 2
	GOTO       L_SelectMode161
	MOVF       _ModeCnt+0, 0
	XORLW      2
	BTFSC      STATUS+0, 2
	GOTO       L_SelectMode162
	MOVF       _ModeCnt+0, 0
	XORLW      3
	BTFSC      STATUS+0, 2
	GOTO       L_SelectMode163
L_SelectMode160:
;si5351SDR_firmware.c,77 :: 		sendRegister(SI_PLL_RESET, 0xA0);
	MOVLW      177
	MOVWF      FARG_sendRegister+0
	MOVLW      160
	MOVWF      FARG_sendRegister+0
	CALL       _sendRegister+0
;si5351SDR_firmware.c,78 :: 		}
L_SelectMode154:
;si5351SDR_firmware.c,79 :: 		}
L_end_SelectMode:
	RETURN
; end of _SelectMode

_Init_Main:

;si5351SDR_firmware.c,81 :: 		void Init_Main(){
;si5351SDR_firmware.c,82 :: 		OSCCON = 0b01111010; //set up for 16 MHZ internal oscillator
	MOVLW      122
	MOVWF      OSCCON+0
;si5351SDR_firmware.c,83 :: 		ANSELA = 0X00; //set up for use as A2D
	CLRF       ANSELA+0
;si5351SDR_firmware.c,84 :: 		ANSELC = 0X00;
	CLRF       ANSELC+0
;si5351SDR_firmware.c,85 :: 		PORTA = 0X00;
	CLRF       PORTA+0
;si5351SDR_firmware.c,86 :: 		TRISA = 0xFF;
	MOVLW      255
	MOVWF      TRISA+0
;si5351SDR_firmware.c,87 :: 		TRISC = 0x00;
	CLRF       TRISC+0
;si5351SDR_firmware.c,88 :: 		PORTC = 0X00;
	CLRF       PORTC+0
;si5351SDR_firmware.c,89 :: 		APFCON0 = 0x00;
	CLRF       APFCON0+0
;si5351SDR_firmware.c,90 :: 		APFCON1 = 0x00;
	CLRF       APFCON1+0
;si5351SDR_firmware.c,91 :: 		INLVLA = 0x00;
	CLRF       INLVLA+0
;si5351SDR_firmware.c,92 :: 		I2C1_Init(400000);
	MOVLW      10
	MOVWF      SSP1ADD+0
	CALL       _I2C1_Init+0
;si5351SDR_firmware.c,93 :: 		delay_ms(20);
	MOVLW      104
	MOVWF      R12
	MOVLW      228
	MOVWF      R13
L_Init_Main164:
	DECFSZ     R13, 1
	GOTO       L_Init_Main164
	DECFSZ     R12, 1
	GOTO       L_Init_Main164
	NOP
;si5351SDR_firmware.c,94 :: 		sendRegister(CLK_ENABLE_CONTROL, 0x04);
	MOVLW      3
	MOVWF      FARG_sendRegister+0
	MOVLW      4
	MOVWF      FARG_sendRegister+0
	CALL       _sendRegister+0
;si5351SDR_firmware.c,95 :: 		sendRegister(SI_CLK0_CONTROL, 0x0F);
	MOVLW      16
	MOVWF      FARG_sendRegister+0
	MOVLW      15
	MOVWF      FARG_sendRegister+0
	CALL       _sendRegister+0
;si5351SDR_firmware.c,96 :: 		sendRegister(SI_CLK1_CONTROL, 0x0F);
	MOVLW      17
	MOVWF      FARG_sendRegister+0
	MOVLW      15
	MOVWF      FARG_sendRegister+0
	CALL       _sendRegister+0
;si5351SDR_firmware.c,97 :: 		si5351aSetFrequency(freq);
	MOVF       _Freq+0, 0
	MOVWF      FARG_si5351aSetFrequency+0
	MOVF       _Freq+1, 0
	MOVWF      FARG_si5351aSetFrequency+1
	MOVF       _Freq+2, 0
	MOVWF      FARG_si5351aSetFrequency+2
	MOVF       _Freq+3, 0
	MOVWF      FARG_si5351aSetFrequency+3
	CALL       _si5351aSetFrequency+0
;si5351SDR_firmware.c,98 :: 		sendRegister(SI_PLL_RESET, 0xA0);
	MOVLW      177
	MOVWF      FARG_sendRegister+0
	MOVLW      160
	MOVWF      FARG_sendRegister+0
	CALL       _sendRegister+0
;si5351SDR_firmware.c,99 :: 		StepVal = 1000;
	MOVLW      232
	MOVWF      _StepVal+0
	MOVLW      3
	MOVWF      _StepVal+1
	CLRF       _StepVal+2
	CLRF       _StepVal+3
;si5351SDR_firmware.c,101 :: 		SSD1306_Begin(SSD1306_SWITCHCAPVCC, SSD1306_I2C_ADDRESS);
	MOVLW      2
	MOVWF      FARG_SSD1306_Begin_vccstate+0
	MOVLW      120
	MOVWF      FARG_SSD1306_Begin_i2caddr+0
	CALL       _SSD1306_Begin+0
;si5351SDR_firmware.c,102 :: 		SSD1306_ClearDisplay();
	CALL       _SSD1306_ClearDisplay+0
;si5351SDR_firmware.c,103 :: 		SSD1306_Color = true;
	MOVLW      1
	MOVWF      _SSD1306_Color+0
;si5351SDR_firmware.c,104 :: 		SSD1306_TextSize(1);
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
;si5351SDR_firmware.c,105 :: 		SSD1306_GotoXY(110,23);
	MOVLW      110
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      23
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
;si5351SDR_firmware.c,106 :: 		SSD1306_Print("MHz");
	MOVLW      ?lstr11_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr11_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
;si5351SDR_firmware.c,107 :: 		DisplayFreq();
	CALL       _DisplayFreq+0
;si5351SDR_firmware.c,108 :: 		SSD1306_TextSize(2);
	MOVLW      2
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
;si5351SDR_firmware.c,109 :: 		print_AM;
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      1
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr12_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr12_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
;si5351SDR_firmware.c,110 :: 		print_1KHz;
	MOVLW      1
	MOVWF      FARG_SSD1306_TextSize_t_size+0
	CALL       _SSD1306_TextSize+0
	MOVLW      91
	MOVWF      FARG_SSD1306_GotoXY_x+0
	MOVLW      4
	MOVWF      FARG_SSD1306_GotoXY_y+0
	CALL       _SSD1306_GotoXY+0
	MOVLW      ?lstr13_si5351SDR_firmware+0
	MOVWF      FARG_SSD1306_Print_s+0
	MOVLW      hi_addr(?lstr13_si5351SDR_firmware+0)
	MOVWF      FARG_SSD1306_Print_s+1
	CALL       _SSD1306_Print+0
	CALL       _SSD1306_Display+0
;si5351SDR_firmware.c,111 :: 		}
L_end_Init_Main:
	RETURN
; end of _Init_Main

_main:

;si5351SDR_firmware.c,113 :: 		void main() {
;si5351SDR_firmware.c,114 :: 		Init_Main();
	CALL       _Init_Main+0
;si5351SDR_firmware.c,115 :: 		while(1){
L_main165:
;si5351SDR_firmware.c,116 :: 		if(Controls()){
	CALL       _Controls+0
	MOVF       R0, 0
	BTFSC      STATUS+0, 2
	GOTO       L_main167
;si5351SDR_firmware.c,117 :: 		si5351aSetFrequency(freq);
	MOVF       _Freq+0, 0
	MOVWF      FARG_si5351aSetFrequency+0
	MOVF       _Freq+1, 0
	MOVWF      FARG_si5351aSetFrequency+1
	MOVF       _Freq+2, 0
	MOVWF      FARG_si5351aSetFrequency+2
	MOVF       _Freq+3, 0
	MOVWF      FARG_si5351aSetFrequency+3
	CALL       _si5351aSetFrequency+0
;si5351SDR_firmware.c,118 :: 		DisplayFreq();
	CALL       _DisplayFreq+0
;si5351SDR_firmware.c,119 :: 		}
L_main167:
;si5351SDR_firmware.c,120 :: 		}
	GOTO       L_main165
;si5351SDR_firmware.c,121 :: 		}
L_end_main:
	GOTO       $+0
; end of _main
